/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
`include "nrm.vh"

module nrm20(CLK, RST,
           SET, SADDR, SDIN, 
           MRE, MDOUT,
           NID, DU,
           START);
   
   input          CLK, RST;

   input [5:0]    SET;
   input [7:0]    NID;
   input          START;

   input [10:0]   SADDR;
   input [31:0]   SDIN;
   input [1:0]    DU;

   input          MRE;
   output [31:0]  MDOUT;

   // DUNIT001
   wire [5:0]     SET001;
   wire           MRE001, START001;
   wire [31:0]    MDOUT001, DIN001, DOUT001;
   wire [1:0]     IREQ001, OREQ001;
   wire           IRDY001, ORDY001;
   // DUNIT002
   wire [5:0]     SET002;
   wire           MRE002, START002;
   wire [31:0]    MDOUT002, DIN002, DOUT002;
   wire [1:0]     IREQ002, OREQ002;
   wire           IRDY002, ORDY002;
   // DUNIT003
   wire [5:0]     SET003;
   wire           MRE003, START003;
   wire [31:0]    MDOUT003, DIN003, DOUT003;
   wire [1:0]     IREQ003, OREQ003;
   wire           IRDY003, ORDY003;
   // DUNIT004
   wire [5:0]     SET004;
   wire           MRE004, START004;
   wire [31:0]    MDOUT004, DIN004, DOUT004;
   wire [1:0]     IREQ004, OREQ004;
   wire           IRDY004, ORDY004;
   // DUNIT005
   wire [5:0]     SET005;
   wire           MRE005, START005;
   wire [31:0]    MDOUT005, DIN005, DOUT005;
   wire [1:0]     IREQ005, OREQ005;
   wire           IRDY005, ORDY005;
   // DUNIT006
   wire [5:0]     SET006;
   wire           MRE006, START006;
   wire [31:0]    MDOUT006, DIN006, DOUT006;
   wire [1:0]     IREQ006, OREQ006;
   wire           IRDY006, ORDY006;
   // DUNIT007
   wire [5:0]     SET007;
   wire           MRE007, START007;
   wire [31:0]    MDOUT007, DIN007, DOUT007;
   wire [1:0]     IREQ007, OREQ007;
   wire           IRDY007, ORDY007;
   // DUNIT008
   wire [5:0]     SET008;
   wire           MRE008, START008;
   wire [31:0]    MDOUT008, DIN008, DOUT008;
   wire [1:0]     IREQ008, OREQ008;
   wire           IRDY008, ORDY008;
   // DUNIT009
   wire [5:0]     SET009;
   wire           MRE009, START009;
   wire [31:0]    MDOUT009, DIN009, DOUT009;
   wire [1:0]     IREQ009, OREQ009;
   wire           IRDY009, ORDY009;
   // DUNIT010
   wire [5:0]     SET010;
   wire           MRE010, START010;
   wire [31:0]    MDOUT010, DIN010, DOUT010;
   wire [1:0]     IREQ010, OREQ010;
   wire           IRDY010, ORDY010;
   // DUNIT011
   wire [5:0]     SET011;
   wire           MRE011, START011;
   wire [31:0]    MDOUT011, DIN011, DOUT011;
   wire [1:0]     IREQ011, OREQ011;
   wire           IRDY011, ORDY011;
   // DUNIT012
   wire [5:0]     SET012;
   wire           MRE012, START012;
   wire [31:0]    MDOUT012, DIN012, DOUT012;
   wire [1:0]     IREQ012, OREQ012;
   wire           IRDY012, ORDY012;
   // DUNIT013
   wire [5:0]     SET013;
   wire           MRE013, START013;
   wire [31:0]    MDOUT013, DIN013, DOUT013;
   wire [1:0]     IREQ013, OREQ013;
   wire           IRDY013, ORDY013;
   // DUNIT014
   wire [5:0]     SET014;
   wire           MRE014, START014;
   wire [31:0]    MDOUT014, DIN014, DOUT014;
   wire [1:0]     IREQ014, OREQ014;
   wire           IRDY014, ORDY014;
   // DUNIT015
   wire [5:0]     SET015;
   wire           MRE015, START015;
   wire [31:0]    MDOUT015, DIN015, DOUT015;
   wire [1:0]     IREQ015, OREQ015;
   wire           IRDY015, ORDY015;
   // DUNIT016
   wire [5:0]     SET016;
   wire           MRE016, START016;
   wire [31:0]    MDOUT016, DIN016, DOUT016;
   wire [1:0]     IREQ016, OREQ016;
   wire           IRDY016, ORDY016;
   // DUNIT017
   wire [5:0]     SET017;
   wire           MRE017, START017;
   wire [31:0]    MDOUT017, DIN017, DOUT017;
   wire [1:0]     IREQ017, OREQ017;
   wire           IRDY017, ORDY017;
   // DUNIT018
   wire [5:0]     SET018;
   wire           MRE018, START018;
   wire [31:0]    MDOUT018, DIN018, DOUT018;
   wire [1:0]     IREQ018, OREQ018;
   wire           IRDY018, ORDY018;
   // DUNIT019
   wire [5:0]     SET019;
   wire           MRE019, START019;
   wire [31:0]    MDOUT019, DIN019, DOUT019;
   wire [1:0]     IREQ019, OREQ019;
   wire           IRDY019, ORDY019;
   // DUNIT020
   wire [5:0]     SET020;
   wire           MRE020, START020;
   wire [31:0]    MDOUT020, DIN020, DOUT020;
   wire [1:0]     IREQ020, OREQ020;
   wire           IRDY020, ORDY020;




   // UPDT800
   wire [5:0]  SET800;
   wire [1:0]  IREQ800;
   wire        IRDY800;
   wire [31:0] DIN800;

   wire [1:0]  OREQ800;
   wire        ORDY800;
   wire [31:0] DOUT800;

   // DGTB700
   wire [5:0]  SET700;
   wire [1:0]  IREQ700;
   wire        IRDY700;
   wire [31:0] DIN700;

   wire [1:0]  OREQ700;
   wire        ORDY700;
   wire [31:0] DOUT700;

   // PCAL500
   wire [5:0]  SET500;
   wire [1:0]  IREQ500;
   wire        IRDY500;
   wire [31:0] DIN500;

   wire [1:0]  OREQ500;
   wire        ORDY500;
   wire [31:0] DOUT500;

   // TCAL400
   wire [5:0]  SET400;
   wire [1:0]  IREQ400;
   wire        IRDY400;
   wire [31:0] DIN400;

   wire [1:0]  OREQ400;
   wire        ORDY400;
   wire [31:0] DOUT400;

   // TMOD300
   wire [1:0]  IREQ300;
   wire        IRDY300;
   wire [31:0] DIN300;

   wire [1:0]  OREQ300;
   wire        ORDY300;
   wire [31:0] DOUT300;

   // DEMUX001
   wire [31:0] DMO001, DMO002, DMO003, DMO004;
   wire [31:0] DMO005, DMO006, DMO007, DMO008;
   wire [31:0] DMO009, DMO010, DMO011, DMO012;
   wire [31:0] DMO013, DMO014, DMO015, DMO016;
   wire [31:0] DMO017, DMO018, DMO019, DMO020;

   wire [31:0] DMO800, DMO700, DMO500, DMO400, DMO300;
   
   // UPDT800
   assign      SET800 = (NID == 8'd80) ? SET : 6'b0;

   cunit_updt updt800(.CLK(CLK),
                      .UWE(SET800[1:0]), .UDADR(SADDR), .UDDIN(SDIN),
                      .IREQ0(IREQ800), .IRDY0(IRDY800), .DIN0(DIN800),
                      .OREQ0(OREQ800), .ORDY0(ORDY800), .DOUT0(DOUT800),
                      .RST(RST));


   // DGTB700
   assign      SET700 = (NID == 8'd70) ? SET : 6'b0;

   cunit_dgtb dgtb700(.CLK(CLK),
                      .DGWE(SET700[0]), .DGDIN(SDIN),
                      .IREQ0(IREQ700), .IRDY0(IRDY700), .DIN0(DIN700),
                      .OREQ0(OREQ700), .ORDY0(ORDY700), .DOUT0(DOUT700),
                      .RST(RST));

   // PCAL500
   assign      SET500 = (NID == 8'd50) ? SET : 6'b0;

   cunit_pcal pcal500(.CLK(CLK),
                      .RCWE(SET500[0]), .RCADR(SADDR[9:0]), .RCDIN(SDIN),
                      .IREQ0(IREQ500), .IRDY0(IRDY500), .DIN0(DIN500),
                      .OREQ0(OREQ500), .ORDY0(ORDY500), .DOUT0(DOUT500),
                      .RST(RST));

   // TCAL400
   assign      SET400 = (NID == 8'd40) ? SET : 6'b0;

   cunit_tcal tcal400(.CLK(CLK),
                     .SET(SET400[0]), .RNDIN(SDIN),
                      .IREQ0(IREQ400), .IRDY0(IRDY400), .DIN0(DIN400),
                      .OREQ0(OREQ400), .ORDY0(ORDY400), .DOUT0(DOUT400),
                      .RST(RST));
   // TMOD300

   cunit_tmod tmod300(.CLK(CLK), 
                      .IREQ0(IREQ300), .IRDY0(IRDY300), .DIN0(DIN300),
                      .OREQ0(OREQ300), .ORDY0(ORDY300), .DOUT0(DOUT300),
                      .RST(RST));

   // ============================================================================
   wire [1:0]  OREQ801, OREQ802, OREQ803, OREQ804, OREQ805, OREQ806, OREQ807, OREQ808;
   wire [1:0]  OREQ701, OREQ702, OREQ703, OREQ704, OREQ705, OREQ706, OREQ707, OREQ708;
   wire [1:0]  OREQ501, OREQ502, OREQ503, OREQ504, OREQ505, OREQ506, OREQ507, OREQ508;
   wire [1:0]  OREQ401, OREQ402, OREQ403, OREQ404, OREQ405, OREQ406, OREQ407, OREQ408;
   wire [1:0]  OREQ301, OREQ302, OREQ303, OREQ304, OREQ305, OREQ306, OREQ307, OREQ308;
   wire [1:0]  OREQ809, OREQ810, OREQ811, OREQ812, OREQ813, OREQ814, OREQ815, OREQ816;
   wire [1:0]  OREQ709, OREQ710, OREQ711, OREQ712, OREQ713, OREQ714, OREQ715, OREQ716;
   wire [1:0]  OREQ509, OREQ510, OREQ511, OREQ512, OREQ513, OREQ514, OREQ515, OREQ516;
   wire [1:0]  OREQ409, OREQ410, OREQ411, OREQ412, OREQ413, OREQ414, OREQ415, OREQ416;
   wire [1:0]  OREQ309, OREQ310, OREQ311, OREQ312, OREQ313, OREQ314, OREQ315, OREQ316;
   wire [1:0]  OREQ817, OREQ818, OREQ819, OREQ820;
   wire [1:0]  OREQ717, OREQ718, OREQ719, OREQ720;
   wire [1:0]  OREQ517, OREQ518, OREQ519, OREQ520;
   wire [1:0]  OREQ417, OREQ418, OREQ419, OREQ420;
   wire [1:0]  OREQ317, OREQ318, OREQ319, OREQ320;
   wire [1:0]  OREQ217, OREQ218, OREQ219, OREQ220;

   wire  ORDY801, ORDY802, ORDY803, ORDY804, ORDY805, ORDY806, ORDY807, ORDY808;
   wire  ORDY701, ORDY702, ORDY703, ORDY704, ORDY705, ORDY706, ORDY707, ORDY708;
   wire  ORDY501, ORDY502, ORDY503, ORDY504, ORDY505, ORDY506, ORDY507, ORDY508;
   wire  ORDY401, ORDY402, ORDY403, ORDY404, ORDY405, ORDY406, ORDY407, ORDY408;
   wire  ORDY301, ORDY302, ORDY303, ORDY304, ORDY305, ORDY306, ORDY307, ORDY308;
   wire  ORDY809, ORDY810, ORDY811, ORDY812, ORDY813, ORDY814, ORDY815, ORDY816;
   wire  ORDY709, ORDY710, ORDY711, ORDY712, ORDY713, ORDY714, ORDY715, ORDY716;
   wire  ORDY509, ORDY510, ORDY511, ORDY512, ORDY513, ORDY514, ORDY515, ORDY516;
   wire  ORDY409, ORDY410, ORDY411, ORDY412, ORDY413, ORDY414, ORDY415, ORDY416;
   wire  ORDY309, ORDY310, ORDY311, ORDY312, ORDY313, ORDY314, ORDY315, ORDY316;
   wire  ORDY817, ORDY818, ORDY819, ORDY820;
   wire  ORDY717, ORDY718, ORDY719, ORDY720;
   wire  ORDY517, ORDY518, ORDY519, ORDY520;
   wire  ORDY417, ORDY418, ORDY419, ORDY420;
   wire  ORDY317, ORDY318, ORDY319, ORDY320;
   wire  ORDY217, ORDY218, ORDY219, ORDY220;

   wire [31:0]  DOUT801, DOUT802, DOUT803, DOUT804, DOUT805, DOUT806, DOUT807, DOUT808;
   wire [31:0]  DOUT701, DOUT702, DOUT703, DOUT704, DOUT705, DOUT706, DOUT707, DOUT708;
   wire [31:0]  DOUT501, DOUT502, DOUT503, DOUT504, DOUT505, DOUT506, DOUT507, DOUT508;
   wire [31:0]  DOUT401, DOUT402, DOUT403, DOUT404, DOUT405, DOUT406, DOUT407, DOUT408;
   wire [31:0]  DOUT301, DOUT302, DOUT303, DOUT304, DOUT305, DOUT306, DOUT307, DOUT308;
   wire [31:0]  DOUT809, DOUT810, DOUT811, DOUT812, DOUT813, DOUT814, DOUT815, DOUT816;
   wire [31:0]  DOUT709, DOUT710, DOUT711, DOUT712, DOUT713, DOUT714, DOUT715, DOUT716;
   wire [31:0]  DOUT509, DOUT510, DOUT511, DOUT512, DOUT513, DOUT514, DOUT515, DOUT516;
   wire [31:0]  DOUT409, DOUT410, DOUT411, DOUT412, DOUT413, DOUT414, DOUT415, DOUT416;
   wire [31:0]  DOUT309, DOUT310, DOUT311, DOUT312, DOUT313, DOUT314, DOUT315, DOUT316;
   wire [31:0]  DOUT817, DOUT818, DOUT819, DOUT820;
   wire [31:0]  DOUT717, DOUT718, DOUT719, DOUT720;
   wire [31:0]  DOUT517, DOUT518, DOUT519, DOUT520;
   wire [31:0]  DOUT417, DOUT418, DOUT419, DOUT420;
   wire [31:0]  DOUT317, DOUT318, DOUT319, DOUT320;
   wire [31:0]  DOUT217, DOUT218, DOUT219, DOUT220;

   wire [1:0]  IREQ801, IREQ802, IREQ803, IREQ804, IREQ805, IREQ806, IREQ807, IREQ808;
   wire [1:0]  IREQ701, IREQ702, IREQ703, IREQ704, IREQ705, IREQ706, IREQ707, IREQ708;
   wire [1:0]  IREQ501, IREQ502, IREQ503, IREQ504, IREQ505, IREQ506, IREQ507, IREQ508;
   wire [1:0]  IREQ401, IREQ402, IREQ403, IREQ404, IREQ405, IREQ406, IREQ407, IREQ408;
   wire [1:0]  IREQ301, IREQ302, IREQ303, IREQ304, IREQ305, IREQ306, IREQ307, IREQ308;
   wire [1:0]  IREQ201, IREQ202, IREQ203, IREQ204, IREQ205, IREQ206, IREQ207, IREQ208;
   wire [1:0]  IREQ809, IREQ810, IREQ811, IREQ812, IREQ813, IREQ814, IREQ815, IREQ816;
   wire [1:0]  IREQ709, IREQ710, IREQ711, IREQ712, IREQ713, IREQ714, IREQ715, IREQ716;
   wire [1:0]  IREQ509, IREQ510, IREQ511, IREQ512, IREQ513, IREQ514, IREQ515, IREQ516;
   wire [1:0]  IREQ409, IREQ410, IREQ411, IREQ412, IREQ413, IREQ414, IREQ415, IREQ416;
   wire [1:0]  IREQ309, IREQ310, IREQ311, IREQ312, IREQ313, IREQ314, IREQ315, IREQ316;
   wire [1:0]  IREQ209, IREQ210, IREQ211, IREQ212, IREQ213, IREQ214, IREQ215, IREQ216;
   wire [1:0]  IREQ817, IREQ818, IREQ819, IREQ820;
   wire [1:0]  IREQ717, IREQ718, IREQ719, IREQ720;
   wire [1:0]  IREQ517, IREQ518, IREQ519, IREQ520;
   wire [1:0]  IREQ417, IREQ418, IREQ419, IREQ420;
   wire [1:0]  IREQ317, IREQ318, IREQ319, IREQ320;
   wire [1:0]  IREQ217, IREQ218, IREQ219, IREQ220;

   wire  IRDY801, IRDY802, IRDY803, IRDY804, IRDY805, IRDY806, IRDY807, IRDY808;
   wire  IRDY701, IRDY702, IRDY703, IRDY704, IRDY705, IRDY706, IRDY707, IRDY708;
   wire  IRDY501, IRDY502, IRDY503, IRDY504, IRDY505, IRDY506, IRDY507, IRDY508;
   wire  IRDY401, IRDY402, IRDY403, IRDY404, IRDY405, IRDY406, IRDY407, IRDY408;
   wire  IRDY301, IRDY302, IRDY303, IRDY304, IRDY305, IRDY306, IRDY307, IRDY308;
   wire  IRDY201, IRDY202, IRDY203, IRDY204, IRDY205, IRDY206, IRDY207, IRDY208;
   wire  IRDY809, IRDY810, IRDY811, IRDY812, IRDY813, IRDY814, IRDY815, IRDY816;
   wire  IRDY709, IRDY710, IRDY711, IRDY712, IRDY713, IRDY714, IRDY715, IRDY716;
   wire  IRDY509, IRDY510, IRDY511, IRDY512, IRDY513, IRDY514, IRDY515, IRDY516;
   wire  IRDY409, IRDY410, IRDY411, IRDY412, IRDY413, IRDY414, IRDY415, IRDY416;
   wire  IRDY309, IRDY310, IRDY311, IRDY312, IRDY313, IRDY314, IRDY315, IRDY316;
   wire  IRDY209, IRDY210, IRDY211, IRDY212, IRDY213, IRDY214, IRDY215, IRDY216;
   wire  IRDY817, IRDY818, IRDY819, IRDY820;
   wire  IRDY717, IRDY718, IRDY719, IRDY720;
   wire  IRDY517, IRDY518, IRDY519, IRDY520;
   wire  IRDY417, IRDY418, IRDY419, IRDY420;
   wire  IRDY317, IRDY318, IRDY319, IRDY320;
   wire  IRDY217, IRDY218, IRDY219, IRDY220;

   bus20   bus801(.CLK(CLK),
                 .IREQ0(IREQ801), .IRDY0(IRDY801), .DIN0(DMO001),
                 .IREQ1(IREQ802), .IRDY1(IRDY802), .DIN1(DMO002),
                 .IREQ2(IREQ803), .IRDY2(IRDY803), .DIN2(DMO003),
                 .IREQ3(IREQ804), .IRDY3(IRDY804), .DIN3(DMO004),
                 .IREQ4(IREQ805), .IRDY4(IRDY805), .DIN4(DMO005),
                 .IREQ5(IREQ806), .IRDY5(IRDY806), .DIN5(DMO006),
                 .IREQ6(IREQ807), .IRDY6(IRDY807), .DIN6(DMO007),
                 .IREQ7(IREQ808), .IRDY7(IRDY808), .DIN7(DMO008),
                 .IREQ8(IREQ809), .IRDY8(IRDY809), .DIN8(DMO009),
                 .IREQ9(IREQ810), .IRDY9(IRDY810), .DIN9(DMO010),
                 .IREQ10(IREQ811), .IRDY10(IRDY811), .DIN10(DMO011),
                 .IREQ11(IREQ812), .IRDY11(IRDY812), .DIN11(DMO012),
                 .IREQ12(IREQ813), .IRDY12(IRDY813), .DIN12(DMO013),
                 .IREQ13(IREQ814), .IRDY13(IRDY814), .DIN13(DMO014),
                 .IREQ14(IREQ815), .IRDY14(IRDY815), .DIN14(DMO015),
                 .IREQ15(IREQ816), .IRDY15(IRDY816), .DIN15(DMO016),
                 .IREQ16(IREQ817), .IRDY16(IRDY817), .DIN16(DMO017),
                 .IREQ17(IREQ818), .IRDY17(IRDY818), .DIN17(DMO018),
                 .IREQ18(IREQ819), .IRDY18(IRDY819), .DIN18(DMO019),
                 .IREQ19(IREQ820), .IRDY19(IRDY820), .DIN19(DMO020),
                 .OREQ(IREQ800),  .ORDY(IRDY800),  .DOUT(DIN800),
                 .RST(RST));

   bus20  bus701(.CLK(CLK),
                 .IREQ0(IREQ701), .IRDY0(IRDY701), .DIN0(DMO001),
                 .IREQ1(IREQ702), .IRDY1(IRDY702), .DIN1(DMO002),
                 .IREQ2(IREQ703), .IRDY2(IRDY703), .DIN2(DMO003),
                 .IREQ3(IREQ704), .IRDY3(IRDY704), .DIN3(DMO004),
                 .IREQ4(IREQ705), .IRDY4(IRDY705), .DIN4(DMO005),
                 .IREQ5(IREQ706), .IRDY5(IRDY706), .DIN5(DMO006),
                 .IREQ6(IREQ707), .IRDY6(IRDY707), .DIN6(DMO007),
                 .IREQ7(IREQ708), .IRDY7(IRDY708), .DIN7(DMO008),
                 .IREQ8(IREQ709), .IRDY8(IRDY709), .DIN8(DMO009),
                 .IREQ9(IREQ710), .IRDY9(IRDY710), .DIN9(DMO010),
                 .IREQ10(IREQ711), .IRDY10(IRDY711), .DIN10(DMO011),
                 .IREQ11(IREQ712), .IRDY11(IRDY712), .DIN11(DMO012),
                 .IREQ12(IREQ713), .IRDY12(IRDY713), .DIN12(DMO013),
                 .IREQ13(IREQ714), .IRDY13(IRDY714), .DIN13(DMO014),
                 .IREQ14(IREQ715), .IRDY14(IRDY715), .DIN14(DMO015),
                 .IREQ15(IREQ716), .IRDY15(IRDY716), .DIN15(DMO016),
                 .IREQ16(IREQ717), .IRDY16(IRDY717), .DIN16(DMO017),
                 .IREQ17(IREQ718), .IRDY17(IRDY718), .DIN17(DMO018),
                 .IREQ18(IREQ719), .IRDY18(IRDY719), .DIN18(DMO019),
                 .IREQ19(IREQ720), .IRDY19(IRDY720), .DIN19(DMO020),
                 .OREQ(IREQ700),  .ORDY(IRDY700),  .DOUT(DIN700),
                 .RST(RST));

   bus20   bus501(.CLK(CLK),
                 .IREQ0(IREQ501), .IRDY0(IRDY501), .DIN0(DMO001),
                 .IREQ1(IREQ502), .IRDY1(IRDY502), .DIN1(DMO002),
                 .IREQ2(IREQ503), .IRDY2(IRDY503), .DIN2(DMO003),
                 .IREQ3(IREQ504), .IRDY3(IRDY504), .DIN3(DMO004),
                 .IREQ4(IREQ505), .IRDY4(IRDY505), .DIN4(DMO005),
                 .IREQ5(IREQ506), .IRDY5(IRDY506), .DIN5(DMO006),
                 .IREQ6(IREQ507), .IRDY6(IRDY507), .DIN6(DMO007),
                 .IREQ7(IREQ508), .IRDY7(IRDY508), .DIN7(DMO008),
                 .IREQ8(IREQ509), .IRDY8(IRDY509), .DIN8(DMO009),
                 .IREQ9(IREQ510), .IRDY9(IRDY510), .DIN9(DMO010),
                 .IREQ10(IREQ511), .IRDY10(IRDY511), .DIN10(DMO011),
                 .IREQ11(IREQ512), .IRDY11(IRDY512), .DIN11(DMO012),
                 .IREQ12(IREQ513), .IRDY12(IRDY513), .DIN12(DMO013),
                 .IREQ13(IREQ514), .IRDY13(IRDY514), .DIN13(DMO014),
                 .IREQ14(IREQ515), .IRDY14(IRDY515), .DIN14(DMO015),
                 .IREQ15(IREQ516), .IRDY15(IRDY516), .DIN15(DMO016),
                 .IREQ16(IREQ517), .IRDY16(IRDY517), .DIN16(DMO017),
                 .IREQ17(IREQ518), .IRDY17(IRDY518), .DIN17(DMO018),
                 .IREQ18(IREQ519), .IRDY18(IRDY519), .DIN18(DMO019),
                 .IREQ19(IREQ520), .IRDY19(IRDY520), .DIN19(DMO020),
                 .OREQ(IREQ500),  .ORDY(IRDY500),  .DOUT(DIN500),
                 .RST(RST));

   bus20   bus401(.CLK(CLK),
                 .IREQ0(IREQ401), .IRDY0(IRDY401), .DIN0(DMO001),
                 .IREQ1(IREQ402), .IRDY1(IRDY402), .DIN1(DMO002),
                 .IREQ2(IREQ403), .IRDY2(IRDY403), .DIN2(DMO003),
                 .IREQ3(IREQ404), .IRDY3(IRDY404), .DIN3(DMO004),
                 .IREQ4(IREQ405), .IRDY4(IRDY405), .DIN4(DMO005),
                 .IREQ5(IREQ406), .IRDY5(IRDY406), .DIN5(DMO006),
                 .IREQ6(IREQ407), .IRDY6(IRDY407), .DIN6(DMO007),
                 .IREQ7(IREQ408), .IRDY7(IRDY408), .DIN7(DMO008),
                 .IREQ8(IREQ409), .IRDY8(IRDY409), .DIN8(DMO009),
                 .IREQ9(IREQ410), .IRDY9(IRDY410), .DIN9(DMO010),
                 .IREQ10(IREQ411), .IRDY10(IRDY411), .DIN10(DMO011),
                 .IREQ11(IREQ412), .IRDY11(IRDY412), .DIN11(DMO012),
                 .IREQ12(IREQ413), .IRDY12(IRDY413), .DIN12(DMO013),
                 .IREQ13(IREQ414), .IRDY13(IRDY414), .DIN13(DMO014),
                 .IREQ14(IREQ415), .IRDY14(IRDY415), .DIN14(DMO015),
                 .IREQ15(IREQ416), .IRDY15(IRDY416), .DIN15(DMO016),
                 .IREQ16(IREQ417), .IRDY16(IRDY417), .DIN16(DMO017),
                 .IREQ17(IREQ418), .IRDY17(IRDY418), .DIN17(DMO018),
                 .IREQ18(IREQ419), .IRDY18(IRDY419), .DIN18(DMO019),
                 .IREQ19(IREQ420), .IRDY19(IRDY420), .DIN19(DMO020),
                 .OREQ(IREQ400),  .ORDY(IRDY400),  .DOUT(DIN400),
                 .RST(RST));

   bus20  bus301(.CLK(CLK),
                 .IREQ0(IREQ301), .IRDY0(IRDY301), .DIN0(DMO001),
                 .IREQ1(IREQ302), .IRDY1(IRDY302), .DIN1(DMO002),
                 .IREQ2(IREQ303), .IRDY2(IRDY303), .DIN2(DMO003),
                 .IREQ3(IREQ304), .IRDY3(IRDY304), .DIN3(DMO004),
                 .IREQ4(IREQ305), .IRDY4(IRDY305), .DIN4(DMO005),
                 .IREQ5(IREQ306), .IRDY5(IRDY306), .DIN5(DMO006),
                 .IREQ6(IREQ307), .IRDY6(IRDY307), .DIN6(DMO007),
                 .IREQ7(IREQ308), .IRDY7(IRDY308), .DIN7(DMO008),
                 .IREQ8(IREQ309), .IRDY8(IRDY309), .DIN8(DMO009),
                 .IREQ9(IREQ310), .IRDY9(IRDY310), .DIN9(DMO010),
                 .IREQ10(IREQ311), .IRDY10(IRDY311), .DIN10(DMO011),
                 .IREQ11(IREQ312), .IRDY11(IRDY312), .DIN11(DMO012),
                 .IREQ12(IREQ313), .IRDY12(IRDY313), .DIN12(DMO013),
                 .IREQ13(IREQ314), .IRDY13(IRDY314), .DIN13(DMO014),
                 .IREQ14(IREQ315), .IRDY14(IRDY315), .DIN14(DMO015),
                 .IREQ15(IREQ316), .IRDY15(IRDY316), .DIN15(DMO016),
                 .IREQ16(IREQ317), .IRDY16(IRDY317), .DIN16(DMO017),
                 .IREQ17(IREQ318), .IRDY17(IRDY318), .DIN17(DMO018),
                 .IREQ18(IREQ319), .IRDY18(IRDY319), .DIN18(DMO019),
                 .IREQ19(IREQ320), .IRDY19(IRDY320), .DIN19(DMO020),
                 .OREQ(IREQ300),  .ORDY(IRDY300),  .DOUT(DIN300),
                 .RST(RST));


   demux20 demux801(.CLK(CLK),
                   .IREQ(OREQ800), .IRDY(ORDY800), .DIN(DOUT800), .DOUT(DMO800),
                   .OREQ0(OREQ801), .ORDY0(ORDY801),
                   .OREQ1(OREQ802), .ORDY1(ORDY802),
                   .OREQ2(OREQ803), .ORDY2(ORDY803),
                   .OREQ3(OREQ804), .ORDY3(ORDY804),
                   .OREQ4(OREQ805), .ORDY4(ORDY805),
                   .OREQ5(OREQ806), .ORDY5(ORDY806),
                   .OREQ6(OREQ807), .ORDY6(ORDY807),
                   .OREQ7(OREQ808), .ORDY7(ORDY808),
                   .OREQ8(OREQ809), .ORDY8(ORDY809),
                   .OREQ9(OREQ810), .ORDY9(ORDY810),
                   .OREQ10(OREQ811), .ORDY10(ORDY811),
                   .OREQ11(OREQ812), .ORDY11(ORDY812),
                   .OREQ12(OREQ813), .ORDY12(ORDY813),
                   .OREQ13(OREQ814), .ORDY13(ORDY814),
                   .OREQ14(OREQ815), .ORDY14(ORDY815),
                   .OREQ15(OREQ816), .ORDY15(ORDY816),
                   .OREQ16(OREQ817), .ORDY16(ORDY817),
                   .OREQ17(OREQ818), .ORDY17(ORDY818),
                   .OREQ18(OREQ819), .ORDY18(ORDY819),
                   .OREQ19(OREQ820), .ORDY19(ORDY820),
                   .RST(RST));

   demux20 demux701(.CLK(CLK),
                   .IREQ(OREQ700), .IRDY(ORDY700), .DIN(DOUT700), .DOUT(DMO700),
                   .OREQ0(OREQ701), .ORDY0(ORDY701),
                   .OREQ1(OREQ702), .ORDY1(ORDY702),
                   .OREQ2(OREQ703), .ORDY2(ORDY703),
                   .OREQ3(OREQ704), .ORDY3(ORDY704),
                   .OREQ4(OREQ705), .ORDY4(ORDY705),
                   .OREQ5(OREQ706), .ORDY5(ORDY706),
                   .OREQ6(OREQ707), .ORDY6(ORDY707),
                   .OREQ7(OREQ708), .ORDY7(ORDY708),
                   .OREQ8(OREQ709), .ORDY8(ORDY709),
                   .OREQ9(OREQ710), .ORDY9(ORDY710),
                   .OREQ10(OREQ711), .ORDY10(ORDY711),
                   .OREQ11(OREQ712), .ORDY11(ORDY712),
                   .OREQ12(OREQ713), .ORDY12(ORDY713),
                   .OREQ13(OREQ714), .ORDY13(ORDY714),
                   .OREQ14(OREQ715), .ORDY14(ORDY715),
                   .OREQ15(OREQ716), .ORDY15(ORDY716),
                   .OREQ16(OREQ717), .ORDY16(ORDY717),
                   .OREQ17(OREQ718), .ORDY17(ORDY718),
                   .OREQ18(OREQ719), .ORDY18(ORDY719),
                   .OREQ19(OREQ720), .ORDY19(ORDY720),
                   .RST(RST));

   demux20 demux501(.CLK(CLK),
                   .IREQ(OREQ500), .IRDY(ORDY500), .DIN(DOUT500), .DOUT(DMO500),
                   .OREQ0(OREQ501), .ORDY0(ORDY501),
                   .OREQ1(OREQ502), .ORDY1(ORDY502),
                   .OREQ2(OREQ503), .ORDY2(ORDY503),
                   .OREQ3(OREQ504), .ORDY3(ORDY504),
                   .OREQ4(OREQ505), .ORDY4(ORDY505),
                   .OREQ5(OREQ506), .ORDY5(ORDY506),
                   .OREQ6(OREQ507), .ORDY6(ORDY507),
                   .OREQ7(OREQ508), .ORDY7(ORDY508),
                   .OREQ8(OREQ509), .ORDY8(ORDY509),
                   .OREQ9(OREQ510), .ORDY9(ORDY510),
                   .OREQ10(OREQ511), .ORDY10(ORDY511),
                   .OREQ11(OREQ512), .ORDY11(ORDY512),
                   .OREQ12(OREQ513), .ORDY12(ORDY513),
                   .OREQ13(OREQ514), .ORDY13(ORDY514),
                   .OREQ14(OREQ515), .ORDY14(ORDY515),
                   .OREQ15(OREQ516), .ORDY15(ORDY516),
                   .OREQ16(OREQ517), .ORDY16(ORDY517),
                   .OREQ17(OREQ518), .ORDY17(ORDY518),
                   .OREQ18(OREQ519), .ORDY18(ORDY519),
                   .OREQ19(OREQ520), .ORDY19(ORDY520),
                   .RST(RST));

   demux20 demux401(.CLK(CLK),
                   .IREQ(OREQ400), .IRDY(ORDY400), .DIN(DOUT400), .DOUT(DMO400),
                   .OREQ0(OREQ401), .ORDY0(ORDY401),
                   .OREQ1(OREQ402), .ORDY1(ORDY402),
                   .OREQ2(OREQ403), .ORDY2(ORDY403),
                   .OREQ3(OREQ404), .ORDY3(ORDY404),
                   .OREQ4(OREQ405), .ORDY4(ORDY405),
                   .OREQ5(OREQ406), .ORDY5(ORDY406),
                   .OREQ6(OREQ407), .ORDY6(ORDY407),
                   .OREQ7(OREQ408), .ORDY7(ORDY408),
                   .OREQ8(OREQ409), .ORDY8(ORDY409),
                   .OREQ9(OREQ410), .ORDY9(ORDY410),
                   .OREQ10(OREQ411), .ORDY10(ORDY411),
                   .OREQ11(OREQ412), .ORDY11(ORDY412),
                   .OREQ12(OREQ413), .ORDY12(ORDY413),
                   .OREQ13(OREQ414), .ORDY13(ORDY414),
                   .OREQ14(OREQ415), .ORDY14(ORDY415),
                   .OREQ15(OREQ416), .ORDY15(ORDY416),
                   .OREQ16(OREQ417), .ORDY16(ORDY417),
                   .OREQ17(OREQ418), .ORDY17(ORDY418),
                   .OREQ18(OREQ419), .ORDY18(ORDY419),
                   .OREQ19(OREQ420), .ORDY19(ORDY420),
                   .RST(RST));

   demux20 demux301(.CLK(CLK),
                   .IREQ(OREQ300), .IRDY(ORDY300), .DIN(DOUT300), .DOUT(DMO300),
                   .OREQ0(OREQ301), .ORDY0(ORDY301),
                   .OREQ1(OREQ302), .ORDY1(ORDY302),
                   .OREQ2(OREQ303), .ORDY2(ORDY303),
                   .OREQ3(OREQ304), .ORDY3(ORDY304),
                   .OREQ4(OREQ305), .ORDY4(ORDY305),
                   .OREQ5(OREQ306), .ORDY5(ORDY306),
                   .OREQ6(OREQ307), .ORDY6(ORDY307),
                   .OREQ7(OREQ308), .ORDY7(ORDY308),
                   .OREQ8(OREQ309), .ORDY8(ORDY309),
                   .OREQ9(OREQ310), .ORDY9(ORDY310),
                   .OREQ10(OREQ311), .ORDY10(ORDY311),
                   .OREQ11(OREQ312), .ORDY11(ORDY312),
                   .OREQ12(OREQ313), .ORDY12(ORDY313),
                   .OREQ13(OREQ314), .ORDY13(ORDY314),
                   .OREQ14(OREQ315), .ORDY14(ORDY315),
                   .OREQ15(OREQ316), .ORDY15(ORDY316),
                   .OREQ16(OREQ317), .ORDY16(ORDY317),
                   .OREQ17(OREQ318), .ORDY17(ORDY318),
                   .OREQ18(OREQ319), .ORDY18(ORDY319),
                   .OREQ19(OREQ320), .ORDY19(ORDY320),
                   .RST(RST));
   
   // ============================================================================

   demux6 demux001(.CLK(CLK),
                   .IREQ(OREQ001), .IRDY(ORDY001), .DIN(DOUT001), .DOUT(DMO001),
                   .OREQ0(IREQ801), .ORDY0(IRDY801),
                   .OREQ1(IREQ701), .ORDY1(IRDY701),
                   .OREQ2(IREQ501), .ORDY2(IRDY501),
                   .OREQ3(IREQ401), .ORDY3(IRDY401),
                   .OREQ4(IREQ301), .ORDY4(IRDY301),
                   .OREQ5(IREQ201), .ORDY5(IRDY201),
                   .RST(RST));

   bus6   bus001(.CLK(CLK),
                 .IREQ0(OREQ801), .IRDY0(ORDY801), .DIN0(DMO800),
                 .IREQ1(OREQ701), .IRDY1(ORDY701), .DIN1(DMO700),
                 .IREQ2(OREQ501), .IRDY2(ORDY501), .DIN2(DMO500),
                 .IREQ3(OREQ401), .IRDY3(ORDY401), .DIN3(DMO400),
                 .IREQ4(OREQ301), .IRDY4(ORDY301), .DIN4(DMO300),
                 .IREQ5(IREQ201), .IRDY5(IRDY201), .DIN5(DMO001),
                 .OREQ(IREQ001),  .ORDY(IRDY001),  .DOUT(DIN001),
                 .RST(RST));

   // ============================================================================

   demux6 demux002(.CLK(CLK),
                   .IREQ(OREQ002), .IRDY(ORDY002), .DIN(DOUT002), .DOUT(DMO002),
                   .OREQ0(IREQ802), .ORDY0(IRDY802),
                   .OREQ1(IREQ702), .ORDY1(IRDY702),
                   .OREQ2(IREQ502), .ORDY2(IRDY502),
                   .OREQ3(IREQ402), .ORDY3(IRDY402),
                   .OREQ4(IREQ302), .ORDY4(IRDY302),
                   .OREQ5(IREQ202), .ORDY5(IRDY202),
                   .RST(RST));

   bus6   bus002(.CLK(CLK),
                 .IREQ0(OREQ802), .IRDY0(ORDY802), .DIN0(DMO800),
                 .IREQ1(OREQ702), .IRDY1(ORDY702), .DIN1(DMO700),
                 .IREQ2(OREQ502), .IRDY2(ORDY502), .DIN2(DMO500),
                 .IREQ3(OREQ402), .IRDY3(ORDY402), .DIN3(DMO400),
                 .IREQ4(OREQ302), .IRDY4(ORDY302), .DIN4(DMO300),
                 .IREQ5(IREQ202), .IRDY5(IRDY202), .DIN5(DMO002),
                 .OREQ(IREQ002),  .ORDY(IRDY002),  .DOUT(DIN002),
                 .RST(RST));

   // ============================================================================

   demux6 demux003(.CLK(CLK),
                   .IREQ(OREQ003), .IRDY(ORDY003), .DIN(DOUT003), .DOUT(DMO003),
                   .OREQ0(IREQ803), .ORDY0(IRDY803),
                   .OREQ1(IREQ703), .ORDY1(IRDY703),
                   .OREQ2(IREQ503), .ORDY2(IRDY503),
                   .OREQ3(IREQ403), .ORDY3(IRDY403),
                   .OREQ4(IREQ303), .ORDY4(IRDY303),
                   .OREQ5(IREQ203), .ORDY5(IRDY203),
                   .RST(RST));

   bus6   bus003(.CLK(CLK),
                 .IREQ0(OREQ803), .IRDY0(ORDY803), .DIN0(DMO800),
                 .IREQ1(OREQ703), .IRDY1(ORDY703), .DIN1(DMO700),
                 .IREQ2(OREQ503), .IRDY2(ORDY503), .DIN2(DMO500),
                 .IREQ3(OREQ403), .IRDY3(ORDY403), .DIN3(DMO400),
                 .IREQ4(OREQ303), .IRDY4(ORDY303), .DIN4(DMO300),
                 .IREQ5(IREQ203), .IRDY5(IRDY203), .DIN5(DMO003),
                 .OREQ(IREQ003),  .ORDY(IRDY003),  .DOUT(DIN003),
                 .RST(RST));

   // ============================================================================

   demux6 demux004(.CLK(CLK),
                   .IREQ(OREQ004), .IRDY(ORDY004), .DIN(DOUT004), .DOUT(DMO004),
                   .OREQ0(IREQ804), .ORDY0(IRDY804),
                   .OREQ1(IREQ704), .ORDY1(IRDY704),
                   .OREQ2(IREQ504), .ORDY2(IRDY504),
                   .OREQ3(IREQ404), .ORDY3(IRDY404),
                   .OREQ4(IREQ304), .ORDY4(IRDY304),
                   .OREQ5(IREQ204), .ORDY5(IRDY204),
                   .RST(RST));

   bus6   bus004(.CLK(CLK),
                 .IREQ0(OREQ804), .IRDY0(ORDY804), .DIN0(DMO800),
                 .IREQ1(OREQ704), .IRDY1(ORDY704), .DIN1(DMO700),
                 .IREQ2(OREQ504), .IRDY2(ORDY504), .DIN2(DMO500),
                 .IREQ3(OREQ404), .IRDY3(ORDY404), .DIN3(DMO400),
                 .IREQ4(OREQ304), .IRDY4(ORDY304), .DIN4(DMO300),
                 .IREQ5(IREQ204), .IRDY5(IRDY204), .DIN5(DMO004),
                 .OREQ(IREQ004),  .ORDY(IRDY004),  .DOUT(DIN004),
                 .RST(RST));

   // ============================================================================

   demux6 demux005(.CLK(CLK),
                   .IREQ(OREQ005), .IRDY(ORDY005), .DIN(DOUT005), .DOUT(DMO005),
                   .OREQ0(IREQ805), .ORDY0(IRDY805),
                   .OREQ1(IREQ705), .ORDY1(IRDY705),
                   .OREQ2(IREQ505), .ORDY2(IRDY505),
                   .OREQ3(IREQ405), .ORDY3(IRDY405),
                   .OREQ4(IREQ305), .ORDY4(IRDY305),
                   .OREQ5(IREQ205), .ORDY5(IRDY205),
                   .RST(RST));

   bus6   bus005(.CLK(CLK),
                 .IREQ0(OREQ805), .IRDY0(ORDY805), .DIN0(DMO800),
                 .IREQ1(OREQ705), .IRDY1(ORDY705), .DIN1(DMO700),
                 .IREQ2(OREQ505), .IRDY2(ORDY505), .DIN2(DMO500),
                 .IREQ3(OREQ405), .IRDY3(ORDY405), .DIN3(DMO400),
                 .IREQ4(OREQ305), .IRDY4(ORDY305), .DIN4(DMO300),
                 .IREQ5(IREQ205), .IRDY5(IRDY205), .DIN5(DMO005),
                 .OREQ(IREQ005),  .ORDY(IRDY005),  .DOUT(DIN005),
                 .RST(RST));

   // ============================================================================

   demux6 demux006(.CLK(CLK),
                   .IREQ(OREQ006), .IRDY(ORDY006), .DIN(DOUT006), .DOUT(DMO006),
                   .OREQ0(IREQ806), .ORDY0(IRDY806),
                   .OREQ1(IREQ706), .ORDY1(IRDY706),
                   .OREQ2(IREQ506), .ORDY2(IRDY506),
                   .OREQ3(IREQ406), .ORDY3(IRDY406),
                   .OREQ4(IREQ306), .ORDY4(IRDY306),
                   .OREQ5(IREQ206), .ORDY5(IRDY206),
                   .RST(RST));

   bus6   bus006(.CLK(CLK),
                 .IREQ0(OREQ806), .IRDY0(ORDY806), .DIN0(DMO800),
                 .IREQ1(OREQ706), .IRDY1(ORDY706), .DIN1(DMO700),
                 .IREQ2(OREQ506), .IRDY2(ORDY506), .DIN2(DMO500),
                 .IREQ3(OREQ406), .IRDY3(ORDY406), .DIN3(DMO400),
                 .IREQ4(OREQ306), .IRDY4(ORDY306), .DIN4(DMO300),
                 .IREQ5(IREQ206), .IRDY5(IRDY206), .DIN5(DMO006),
                 .OREQ(IREQ006),  .ORDY(IRDY006),  .DOUT(DIN006),
                 .RST(RST));


   // ============================================================================

   demux6 demux007(.CLK(CLK),
                   .IREQ(OREQ007), .IRDY(ORDY007), .DIN(DOUT007), .DOUT(DMO007),
                   .OREQ0(IREQ807), .ORDY0(IRDY807),
                   .OREQ1(IREQ707), .ORDY1(IRDY707),
                   .OREQ2(IREQ507), .ORDY2(IRDY507),
                   .OREQ3(IREQ407), .ORDY3(IRDY407),
                   .OREQ4(IREQ307), .ORDY4(IRDY307),
                   .OREQ5(IREQ207), .ORDY5(IRDY207),
                   .RST(RST));

   bus6   bus007(.CLK(CLK),
                 .IREQ0(OREQ807), .IRDY0(ORDY807), .DIN0(DMO800),
                 .IREQ1(OREQ707), .IRDY1(ORDY707), .DIN1(DMO700),
                 .IREQ2(OREQ507), .IRDY2(ORDY507), .DIN2(DMO500),
                 .IREQ3(OREQ407), .IRDY3(ORDY407), .DIN3(DMO400),
                 .IREQ4(OREQ307), .IRDY4(ORDY307), .DIN4(DMO300),
                 .IREQ5(IREQ207), .IRDY5(IRDY207), .DIN5(DMO007),
                 .OREQ(IREQ007),  .ORDY(IRDY007),  .DOUT(DIN007),
                 .RST(RST));

   // ============================================================================

   demux6 demux008(.CLK(CLK),
                   .IREQ(OREQ008), .IRDY(ORDY008), .DIN(DOUT008), .DOUT(DMO008),
                   .OREQ0(IREQ808), .ORDY0(IRDY808),
                   .OREQ1(IREQ708), .ORDY1(IRDY708),
                   .OREQ2(IREQ508), .ORDY2(IRDY508),
                   .OREQ3(IREQ408), .ORDY3(IRDY408),
                   .OREQ4(IREQ308), .ORDY4(IRDY308),
                   .OREQ5(IREQ208), .ORDY5(IRDY208),
                   .RST(RST));

   bus6   bus008(.CLK(CLK),
                 .IREQ0(OREQ808), .IRDY0(ORDY808), .DIN0(DMO800),
                 .IREQ1(OREQ708), .IRDY1(ORDY708), .DIN1(DMO700),
                 .IREQ2(OREQ508), .IRDY2(ORDY508), .DIN2(DMO500),
                 .IREQ3(OREQ408), .IRDY3(ORDY408), .DIN3(DMO400),
                 .IREQ4(OREQ308), .IRDY4(ORDY308), .DIN4(DMO300),
                 .IREQ5(IREQ208), .IRDY5(IRDY208), .DIN5(DMO008),
                 .OREQ(IREQ008),  .ORDY(IRDY008),  .DOUT(DIN008),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux009(.CLK(CLK),
                   .IREQ(OREQ009), .IRDY(ORDY009), .DIN(DOUT009), .DOUT(DMO009),
                   .OREQ0(IREQ809), .ORDY0(IRDY809),
                   .OREQ1(IREQ709), .ORDY1(IRDY709),
                   .OREQ2(IREQ509), .ORDY2(IRDY509),
                   .OREQ3(IREQ409), .ORDY3(IRDY409),
                   .OREQ4(IREQ309), .ORDY4(IRDY309),
                   .OREQ5(IREQ209), .ORDY5(IRDY209),
                   .RST(RST));

   bus6   bus009(.CLK(CLK),
                 .IREQ0(OREQ809), .IRDY0(ORDY809), .DIN0(DMO800),
                 .IREQ1(OREQ709), .IRDY1(ORDY709), .DIN1(DMO700),
                 .IREQ2(OREQ509), .IRDY2(ORDY509), .DIN2(DMO500),
                 .IREQ3(OREQ409), .IRDY3(ORDY409), .DIN3(DMO400),
                 .IREQ4(OREQ309), .IRDY4(ORDY309), .DIN4(DMO300),
                 .IREQ5(IREQ209), .IRDY5(IRDY209), .DIN5(DMO009),
                 .OREQ(IREQ009),  .ORDY(IRDY009),  .DOUT(DIN009),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux010(.CLK(CLK),
                   .IREQ(OREQ010), .IRDY(ORDY010), .DIN(DOUT010), .DOUT(DMO010),
                   .OREQ0(IREQ810), .ORDY0(IRDY810),
                   .OREQ1(IREQ710), .ORDY1(IRDY710),
                   .OREQ2(IREQ510), .ORDY2(IRDY510),
                   .OREQ3(IREQ410), .ORDY3(IRDY410),
                   .OREQ4(IREQ310), .ORDY4(IRDY310),
                   .OREQ5(IREQ210), .ORDY5(IRDY210),
                   .RST(RST));

   bus6   bus010(.CLK(CLK),
                 .IREQ0(OREQ810), .IRDY0(ORDY810), .DIN0(DMO800),
                 .IREQ1(OREQ710), .IRDY1(ORDY710), .DIN1(DMO700),
                 .IREQ2(OREQ510), .IRDY2(ORDY510), .DIN2(DMO500),
                 .IREQ3(OREQ410), .IRDY3(ORDY410), .DIN3(DMO400),
                 .IREQ4(OREQ310), .IRDY4(ORDY310), .DIN4(DMO300),
                 .IREQ5(IREQ210), .IRDY5(IRDY210), .DIN5(DMO010),
                 .OREQ(IREQ010),  .ORDY(IRDY010),  .DOUT(DIN010),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux011(.CLK(CLK),
                   .IREQ(OREQ011), .IRDY(ORDY011), .DIN(DOUT011), .DOUT(DMO011),
                   .OREQ0(IREQ811), .ORDY0(IRDY811),
                   .OREQ1(IREQ711), .ORDY1(IRDY711),
                   .OREQ2(IREQ511), .ORDY2(IRDY511),
                   .OREQ3(IREQ411), .ORDY3(IRDY411),
                   .OREQ4(IREQ311), .ORDY4(IRDY311),
                   .OREQ5(IREQ211), .ORDY5(IRDY211),
                   .RST(RST));

   bus6   bus011(.CLK(CLK),
                 .IREQ0(OREQ811), .IRDY0(ORDY811), .DIN0(DMO800),
                 .IREQ1(OREQ711), .IRDY1(ORDY711), .DIN1(DMO700),
                 .IREQ2(OREQ511), .IRDY2(ORDY511), .DIN2(DMO500),
                 .IREQ3(OREQ411), .IRDY3(ORDY411), .DIN3(DMO400),
                 .IREQ4(OREQ311), .IRDY4(ORDY311), .DIN4(DMO300),
                 .IREQ5(IREQ211), .IRDY5(IRDY211), .DIN5(DMO011),
                 .OREQ(IREQ011),  .ORDY(IRDY011),  .DOUT(DIN011),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux012(.CLK(CLK),
                   .IREQ(OREQ012), .IRDY(ORDY012), .DIN(DOUT012), .DOUT(DMO012),
                   .OREQ0(IREQ812), .ORDY0(IRDY812),
                   .OREQ1(IREQ712), .ORDY1(IRDY712),
                   .OREQ2(IREQ512), .ORDY2(IRDY512),
                   .OREQ3(IREQ412), .ORDY3(IRDY412),
                   .OREQ4(IREQ312), .ORDY4(IRDY312),
                   .OREQ5(IREQ212), .ORDY5(IRDY212),
                   .RST(RST));

   bus6   bus012(.CLK(CLK),
                 .IREQ0(OREQ812), .IRDY0(ORDY812), .DIN0(DMO800),
                 .IREQ1(OREQ712), .IRDY1(ORDY712), .DIN1(DMO700),
                 .IREQ2(OREQ512), .IRDY2(ORDY512), .DIN2(DMO500),
                 .IREQ3(OREQ412), .IRDY3(ORDY412), .DIN3(DMO400),
                 .IREQ4(OREQ312), .IRDY4(ORDY312), .DIN4(DMO300),
                 .IREQ5(IREQ212), .IRDY5(IRDY212), .DIN5(DMO012),
                 .OREQ(IREQ012),  .ORDY(IRDY012),  .DOUT(DIN012),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux013(.CLK(CLK),
                   .IREQ(OREQ013), .IRDY(ORDY013), .DIN(DOUT013), .DOUT(DMO013),
                   .OREQ0(IREQ813), .ORDY0(IRDY813),
                   .OREQ1(IREQ713), .ORDY1(IRDY713),
                   .OREQ2(IREQ513), .ORDY2(IRDY513),
                   .OREQ3(IREQ413), .ORDY3(IRDY413),
                   .OREQ4(IREQ313), .ORDY4(IRDY313),
                   .OREQ5(IREQ213), .ORDY5(IRDY213),
                   .RST(RST));

   bus6   bus013(.CLK(CLK),
                 .IREQ0(OREQ813), .IRDY0(ORDY813), .DIN0(DMO800),
                 .IREQ1(OREQ713), .IRDY1(ORDY713), .DIN1(DMO700),
                 .IREQ2(OREQ513), .IRDY2(ORDY513), .DIN2(DMO500),
                 .IREQ3(OREQ413), .IRDY3(ORDY413), .DIN3(DMO400),
                 .IREQ4(OREQ313), .IRDY4(ORDY313), .DIN4(DMO300),
                 .IREQ5(IREQ213), .IRDY5(IRDY213), .DIN5(DMO013),
                 .OREQ(IREQ013),  .ORDY(IRDY013),  .DOUT(DIN013),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux014(.CLK(CLK),
                   .IREQ(OREQ014), .IRDY(ORDY014), .DIN(DOUT014), .DOUT(DMO014),
                   .OREQ0(IREQ814), .ORDY0(IRDY814),
                   .OREQ1(IREQ714), .ORDY1(IRDY714),
                   .OREQ2(IREQ514), .ORDY2(IRDY514),
                   .OREQ3(IREQ414), .ORDY3(IRDY414),
                   .OREQ4(IREQ314), .ORDY4(IRDY314),
                   .OREQ5(IREQ214), .ORDY5(IRDY214),
                   .RST(RST));

   bus6   bus014(.CLK(CLK),
                 .IREQ0(OREQ814), .IRDY0(ORDY814), .DIN0(DMO800),
                 .IREQ1(OREQ714), .IRDY1(ORDY714), .DIN1(DMO700),
                 .IREQ2(OREQ514), .IRDY2(ORDY514), .DIN2(DMO500),
                 .IREQ3(OREQ414), .IRDY3(ORDY414), .DIN3(DMO400),
                 .IREQ4(OREQ314), .IRDY4(ORDY314), .DIN4(DMO300),
                 .IREQ5(IREQ214), .IRDY5(IRDY214), .DIN5(DMO014),
                 .OREQ(IREQ014),  .ORDY(IRDY014),  .DOUT(DIN014),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux015(.CLK(CLK),
                   .IREQ(OREQ015), .IRDY(ORDY015), .DIN(DOUT015), .DOUT(DMO015),
                   .OREQ0(IREQ815), .ORDY0(IRDY815),
                   .OREQ1(IREQ715), .ORDY1(IRDY715),
                   .OREQ2(IREQ515), .ORDY2(IRDY515),
                   .OREQ3(IREQ415), .ORDY3(IRDY415),
                   .OREQ4(IREQ315), .ORDY4(IRDY315),
                   .OREQ5(IREQ215), .ORDY5(IRDY215),
                   .RST(RST));

   bus6   bus015(.CLK(CLK),
                 .IREQ0(OREQ815), .IRDY0(ORDY815), .DIN0(DMO800),
                 .IREQ1(OREQ715), .IRDY1(ORDY715), .DIN1(DMO700),
                 .IREQ2(OREQ515), .IRDY2(ORDY515), .DIN2(DMO500),
                 .IREQ3(OREQ415), .IRDY3(ORDY415), .DIN3(DMO400),
                 .IREQ4(OREQ315), .IRDY4(ORDY315), .DIN4(DMO300),
                 .IREQ5(IREQ215), .IRDY5(IRDY215), .DIN5(DMO015),
                 .OREQ(IREQ015),  .ORDY(IRDY015),  .DOUT(DIN015),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux016(.CLK(CLK),
                   .IREQ(OREQ016), .IRDY(ORDY016), .DIN(DOUT016), .DOUT(DMO016),
                   .OREQ0(IREQ816), .ORDY0(IRDY816),
                   .OREQ1(IREQ716), .ORDY1(IRDY716),
                   .OREQ2(IREQ516), .ORDY2(IRDY516),
                   .OREQ3(IREQ416), .ORDY3(IRDY416),
                   .OREQ4(IREQ316), .ORDY4(IRDY316),
                   .OREQ5(IREQ216), .ORDY5(IRDY216),
                   .RST(RST));

   bus6   bus016(.CLK(CLK),
                 .IREQ0(OREQ816), .IRDY0(ORDY816), .DIN0(DMO800),
                 .IREQ1(OREQ716), .IRDY1(ORDY716), .DIN1(DMO700),
                 .IREQ2(OREQ516), .IRDY2(ORDY516), .DIN2(DMO500),
                 .IREQ3(OREQ416), .IRDY3(ORDY416), .DIN3(DMO400),
                 .IREQ4(OREQ316), .IRDY4(ORDY316), .DIN4(DMO300),
                 .IREQ5(IREQ216), .IRDY5(IRDY216), .DIN5(DMO016),
                 .OREQ(IREQ016),  .ORDY(IRDY016),  .DOUT(DIN016),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux017(.CLK(CLK),
                   .IREQ(OREQ017), .IRDY(ORDY017), .DIN(DOUT017), .DOUT(DMO017),
                   .OREQ0(IREQ817), .ORDY0(IRDY817),
                   .OREQ1(IREQ717), .ORDY1(IRDY717),
                   .OREQ2(IREQ517), .ORDY2(IRDY517),
                   .OREQ3(IREQ417), .ORDY3(IRDY417),
                   .OREQ4(IREQ317), .ORDY4(IRDY317),
                   .OREQ5(IREQ217), .ORDY5(IRDY217),
                   .RST(RST));

   bus6   bus017(.CLK(CLK),
                 .IREQ0(OREQ817), .IRDY0(ORDY817), .DIN0(DMO800),
                 .IREQ1(OREQ717), .IRDY1(ORDY717), .DIN1(DMO700),
                 .IREQ2(OREQ517), .IRDY2(ORDY517), .DIN2(DMO500),
                 .IREQ3(OREQ417), .IRDY3(ORDY417), .DIN3(DMO400),
                 .IREQ4(OREQ317), .IRDY4(ORDY317), .DIN4(DMO300),
                 .IREQ5(IREQ217), .IRDY5(IRDY217), .DIN5(DMO017),
                 .OREQ(IREQ017),  .ORDY(IRDY017),  .DOUT(DIN017),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux018(.CLK(CLK),
                   .IREQ(OREQ018), .IRDY(ORDY018), .DIN(DOUT018), .DOUT(DMO018),
                   .OREQ0(IREQ818), .ORDY0(IRDY818),
                   .OREQ1(IREQ718), .ORDY1(IRDY718),
                   .OREQ2(IREQ518), .ORDY2(IRDY518),
                   .OREQ3(IREQ418), .ORDY3(IRDY418),
                   .OREQ4(IREQ318), .ORDY4(IRDY318),
                   .OREQ5(IREQ218), .ORDY5(IRDY218),
                   .RST(RST));

   bus6   bus018(.CLK(CLK),
                 .IREQ0(OREQ818), .IRDY0(ORDY818), .DIN0(DMO800),
                 .IREQ1(OREQ718), .IRDY1(ORDY718), .DIN1(DMO700),
                 .IREQ2(OREQ518), .IRDY2(ORDY518), .DIN2(DMO500),
                 .IREQ3(OREQ418), .IRDY3(ORDY418), .DIN3(DMO400),
                 .IREQ4(OREQ318), .IRDY4(ORDY318), .DIN4(DMO300),
                 .IREQ5(IREQ218), .IRDY5(IRDY218), .DIN5(DMO018),
                 .OREQ(IREQ018),  .ORDY(IRDY018),  .DOUT(DIN018),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux019(.CLK(CLK),
                   .IREQ(OREQ019), .IRDY(ORDY019), .DIN(DOUT019), .DOUT(DMO019),
                   .OREQ0(IREQ819), .ORDY0(IRDY819),
                   .OREQ1(IREQ719), .ORDY1(IRDY719),
                   .OREQ2(IREQ519), .ORDY2(IRDY519),
                   .OREQ3(IREQ419), .ORDY3(IRDY419),
                   .OREQ4(IREQ319), .ORDY4(IRDY319),
                   .OREQ5(IREQ219), .ORDY5(IRDY219),
                   .RST(RST));

   bus6   bus019(.CLK(CLK),
                 .IREQ0(OREQ819), .IRDY0(ORDY819), .DIN0(DMO800),
                 .IREQ1(OREQ719), .IRDY1(ORDY719), .DIN1(DMO700),
                 .IREQ2(OREQ519), .IRDY2(ORDY519), .DIN2(DMO500),
                 .IREQ3(OREQ419), .IRDY3(ORDY419), .DIN3(DMO400),
                 .IREQ4(OREQ319), .IRDY4(ORDY319), .DIN4(DMO300),
                 .IREQ5(IREQ219), .IRDY5(IRDY219), .DIN5(DMO019),
                 .OREQ(IREQ019),  .ORDY(IRDY019),  .DOUT(DIN019),
                 .RST(RST));
   
   // ============================================================================

   demux6 demux020(.CLK(CLK),
                   .IREQ(OREQ020), .IRDY(ORDY020), .DIN(DOUT020), .DOUT(DMO020),
                   .OREQ0(IREQ820), .ORDY0(IRDY820),
                   .OREQ1(IREQ720), .ORDY1(IRDY720),
                   .OREQ2(IREQ520), .ORDY2(IRDY520),
                   .OREQ3(IREQ420), .ORDY3(IRDY420),
                   .OREQ4(IREQ320), .ORDY4(IRDY320),
                   .OREQ5(IREQ220), .ORDY5(IRDY220),
                   .RST(RST));

   bus6   bus020(.CLK(CLK),
                 .IREQ0(OREQ820), .IRDY0(ORDY820), .DIN0(DMO800),
                 .IREQ1(OREQ720), .IRDY1(ORDY720), .DIN1(DMO700),
                 .IREQ2(OREQ520), .IRDY2(ORDY520), .DIN2(DMO500),
                 .IREQ3(OREQ420), .IRDY3(ORDY420), .DIN3(DMO400),
                 .IREQ4(OREQ320), .IRDY4(ORDY320), .DIN4(DMO300),
                 .IREQ5(IREQ220), .IRDY5(IRDY220), .DIN5(DMO020),
                 .OREQ(IREQ020),  .ORDY(IRDY020),  .DOUT(DIN020),
                 .RST(RST));
   
   // ============================================================================
   
   assign         SET001   = (NID == 8'd1) ? SET : 6'b0;
   assign         MRE001   = (NID == 8'd1) ? MRE : 6'b0;
   assign         START001 = (NID == 8'd1) ? START : `DISABLE;

   dunit dunit1(.CLK(CLK),
                .SET(SET001), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT001),
                .ID(8'd1), .START(START001),
                .IREQ(IREQ001), .IRDY(IRDY001), .DIN(DIN001),
                .OREQ(OREQ001), .ORDY(ORDY001), .DOUT(DOUT001),
                .RST(RST));
   
// ============================================================================
   
   assign         SET002   = (NID == 8'd2) ? SET : 6'b0;
   assign         MRE002   = (NID == 8'd2) ? MRE : 6'b0;
   assign         START002 = (NID == 8'd2) ? START : `DISABLE;

   dunit dunit2(.CLK(CLK),
                .SET(SET002), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT002),
                .ID(8'd2), .START(START002),
                .IREQ(IREQ002), .IRDY(IRDY002), .DIN(DIN002),
                .OREQ(OREQ002), .ORDY(ORDY002), .DOUT(DOUT002),
                .RST(RST));

// ============================================================================
   
   assign         SET003   = (NID == 8'd3) ? SET : 6'b0;
   assign         MRE003   = (NID == 8'd3) ? MRE : 6'b0;
   assign         START003 = (NID == 8'd3) ? START : `DISABLE;

   dunit dunit3(.CLK(CLK),
                .SET(SET003), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT003),
                .ID(8'd3), .START(START003),
                .IREQ(IREQ003), .IRDY(IRDY003), .DIN(DIN003),
                .OREQ(OREQ003), .ORDY(ORDY003), .DOUT(DOUT003),
                .RST(RST));
   
   // ============================================================================
   
   assign         SET004   = (NID == 8'd4) ? SET : 6'b0;
   assign         MRE004   = (NID == 8'd4) ? MRE : 6'b0;
   assign         START004 = (NID == 8'd4) ? START : `DISABLE;

   dunit dunit4(.CLK(CLK),
                .SET(SET004), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT004),
                .ID(8'd4), .START(START004),
                .IREQ(IREQ004), .IRDY(IRDY004), .DIN(DIN004),
                .OREQ(OREQ004), .ORDY(ORDY004), .DOUT(DOUT004),
                .RST(RST));

   // ============================================================================
   assign         SET005   = (NID == 8'd5) ? SET : 6'b0;
   assign         MRE005   = (NID == 8'd5) ? MRE : 6'b0;
   assign         START005 = (NID == 8'd5) ? START : `DISABLE;

   dunit dunit5(.CLK(CLK),
                .SET(SET005), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT005),
                .ID(8'd5), .START(START005),
                .IREQ(IREQ005), .IRDY(IRDY005), .DIN(DIN005),
                .OREQ(OREQ005), .ORDY(ORDY005), .DOUT(DOUT005),
                .RST(RST));

   // ============================================================================
   assign         SET006   = (NID == 8'd6) ? SET : 6'b0;
   assign         MRE006   = (NID == 8'd6) ? MRE : 6'b0;
   assign         START006 = (NID == 8'd6) ? START : `DISABLE;

   dunit dunit6(.CLK(CLK),
                .SET(SET006), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT006),
                .ID(8'd6), .START(START006),
                .IREQ(IREQ006), .IRDY(IRDY006), .DIN(DIN006),
                .OREQ(OREQ006), .ORDY(ORDY006), .DOUT(DOUT006),
                .RST(RST));
   // ============================================================================
   assign         SET007   = (NID == 8'd7) ? SET : 6'b0;
   assign         MRE007   = (NID == 8'd7) ? MRE : 6'b0;
   assign         START007 = (NID == 8'd7) ? START : `DISABLE;

   dunit dunit7(.CLK(CLK),
                .SET(SET007), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT007),
                .ID(8'd7), .START(START007),
                .IREQ(IREQ007), .IRDY(IRDY007), .DIN(DIN007),
                .OREQ(OREQ007), .ORDY(ORDY007), .DOUT(DOUT007),
                .RST(RST));

   // ============================================================================
   assign         SET008   = (NID == 8'd8) ? SET : 6'b0;
   assign         MRE008   = (NID == 8'd8) ? MRE : 6'b0;
   assign         START008 = (NID == 8'd8) ? START : `DISABLE;

   dunit dunit8(.CLK(CLK),
                .SET(SET008), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT008),
                .ID(8'd8), .START(START008),
                .IREQ(IREQ008), .IRDY(IRDY008), .DIN(DIN008),
                .OREQ(OREQ008), .ORDY(ORDY008), .DOUT(DOUT008),
                .RST(RST));

   // ============================================================================
   assign         SET009   = (NID == 8'd9) ? SET : 6'b0;
   assign         MRE009   = (NID == 8'd9) ? MRE : 6'b0;
   assign         START009 = (NID == 8'd9) ? START : `DISABLE;

   dunit dunit9(.CLK(CLK),
                .SET(SET009), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT009),
                .ID(8'd9), .START(START009),
                .IREQ(IREQ009), .IRDY(IRDY009), .DIN(DIN009),
                .OREQ(OREQ009), .ORDY(ORDY009), .DOUT(DOUT009),
                .RST(RST));

   // ============================================================================
   assign         SET010   = (NID == 8'd10) ? SET : 6'b0;
   assign         MRE010   = (NID == 8'd10) ? MRE : 6'b0;
   assign         START010 = (NID == 8'd10) ? START : `DISABLE;

   dunit dunit10(.CLK(CLK),
                .SET(SET010), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT010),
                .ID(8'd10), .START(START010),
                .IREQ(IREQ010), .IRDY(IRDY010), .DIN(DIN010),
                .OREQ(OREQ010), .ORDY(ORDY010), .DOUT(DOUT010),
                .RST(RST));

   // ============================================================================
   assign         SET011   = (NID == 8'd11) ? SET : 6'b0;
   assign         MRE011   = (NID == 8'd11) ? MRE : 6'b0;
   assign         START011 = (NID == 8'd11) ? START : `DISABLE;

   dunit dunit11(.CLK(CLK),
                .SET(SET011), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT011),
                .ID(8'd11), .START(START011),
                .IREQ(IREQ011), .IRDY(IRDY011), .DIN(DIN011),
                .OREQ(OREQ011), .ORDY(ORDY011), .DOUT(DOUT011),
                .RST(RST));

   // ============================================================================
   assign         SET012   = (NID == 8'd12) ? SET : 6'b0;
   assign         MRE012   = (NID == 8'd12) ? MRE : 6'b0;
   assign         START012 = (NID == 8'd12) ? START : `DISABLE;

   dunit dunit12(.CLK(CLK),
                .SET(SET012), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT012),
                .ID(8'd12), .START(START012),
                .IREQ(IREQ012), .IRDY(IRDY012), .DIN(DIN012),
                .OREQ(OREQ012), .ORDY(ORDY012), .DOUT(DOUT012),
                .RST(RST));

   // ============================================================================
   assign         SET013   = (NID == 8'd13) ? SET : 6'b0;
   assign         MRE013   = (NID == 8'd13) ? MRE : 6'b0;
   assign         START013 = (NID == 8'd13) ? START : `DISABLE;

   dunit dunit13(.CLK(CLK),
                .SET(SET013), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT013),
                .ID(8'd13), .START(START013),
                .IREQ(IREQ013), .IRDY(IRDY013), .DIN(DIN013),
                .OREQ(OREQ013), .ORDY(ORDY013), .DOUT(DOUT013),
                .RST(RST));

   // ============================================================================
   assign         SET014   = (NID == 8'd14) ? SET : 6'b0;
   assign         MRE014   = (NID == 8'd14) ? MRE : 6'b0;
   assign         START014 = (NID == 8'd14) ? START : `DISABLE;

   dunit dunit14(.CLK(CLK),
                .SET(SET014), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT014),
                .ID(8'd14), .START(START014),
                .IREQ(IREQ014), .IRDY(IRDY014), .DIN(DIN014),
                .OREQ(OREQ014), .ORDY(ORDY014), .DOUT(DOUT014),
                .RST(RST));

   // ============================================================================
   assign         SET015   = (NID == 8'd15) ? SET : 6'b0;
   assign         MRE015   = (NID == 8'd15) ? MRE : 6'b0;
   assign         START015 = (NID == 8'd15) ? START : `DISABLE;

   dunit dunit15(.CLK(CLK),
                .SET(SET015), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT015),
                .ID(8'd15), .START(START015),
                .IREQ(IREQ015), .IRDY(IRDY015), .DIN(DIN015),
                .OREQ(OREQ015), .ORDY(ORDY015), .DOUT(DOUT015),
                .RST(RST));

   // ============================================================================
   assign         SET016   = (NID == 8'd16) ? SET : 6'b0;
   assign         MRE016   = (NID == 8'd16) ? MRE : 6'b0;
   assign         START016 = (NID == 8'd16) ? START : `DISABLE;

   dunit dunit16(.CLK(CLK),
                .SET(SET016), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT016),
                .ID(8'd16), .START(START016),
                .IREQ(IREQ016), .IRDY(IRDY016), .DIN(DIN016),
                .OREQ(OREQ016), .ORDY(ORDY016), .DOUT(DOUT016),
                .RST(RST));


   // ============================================================================
   assign         SET017   = (NID == 8'd17) ? SET : 6'b0;
   assign         MRE017   = (NID == 8'd17) ? MRE : 6'b0;
   assign         START017 = (NID == 8'd17) ? START : `DISABLE;

   dunit dunit17(.CLK(CLK),
                .SET(SET017), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT017),
                .ID(8'd17), .START(START017),
                .IREQ(IREQ017), .IRDY(IRDY017), .DIN(DIN017),
                .OREQ(OREQ017), .ORDY(ORDY017), .DOUT(DOUT017),
                .RST(RST));


   // ============================================================================
   assign         SET018   = (NID == 8'd18) ? SET : 6'b0;
   assign         MRE018   = (NID == 8'd18) ? MRE : 6'b0;
   assign         START018 = (NID == 8'd18) ? START : `DISABLE;

   dunit dunit18(.CLK(CLK),
                .SET(SET018), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT018),
                .ID(8'd18), .START(START018),
                .IREQ(IREQ018), .IRDY(IRDY018), .DIN(DIN018),
                .OREQ(OREQ018), .ORDY(ORDY018), .DOUT(DOUT018),
                .RST(RST));


   // ============================================================================
   assign         SET019   = (NID == 8'd19) ? SET : 6'b0;
   assign         MRE019   = (NID == 8'd19) ? MRE : 6'b0;
   assign         START019 = (NID == 8'd19) ? START : `DISABLE;

   dunit dunit19(.CLK(CLK),
                .SET(SET019), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT019),
                .ID(8'd19), .START(START019),
                .IREQ(IREQ019), .IRDY(IRDY019), .DIN(DIN019),
                .OREQ(OREQ019), .ORDY(ORDY019), .DOUT(DOUT019),
                .RST(RST));


   // ============================================================================
   assign         SET020   = (NID == 8'd20) ? SET : 6'b0;
   assign         MRE020   = (NID == 8'd20) ? MRE : 6'b0;
   assign         START020 = (NID == 8'd20) ? START : `DISABLE;

   dunit dunit20(.CLK(CLK),
                .SET(SET020), .SADDR(SADDR[9:0]), .SDIN(SDIN),
                .MRE(MRE), .MADDR(SADDR[9:0]), .MDOUT(MDOUT020),
                .ID(8'd20), .START(START020),
                .IREQ(IREQ020), .IRDY(IRDY020), .DIN(DIN020),
                .OREQ(OREQ020), .ORDY(ORDY020), .DOUT(DOUT020),
                .RST(RST));




   reg [31:0]  MDOUT;

   always@(posedge CLK) begin
      casex(NID)
        8'd1 : MDOUT <= MDOUT001;
        8'd2 : MDOUT <= MDOUT002;
        8'd3 : MDOUT <= MDOUT003;
        8'd4 : MDOUT <= MDOUT004;
        8'd5 : MDOUT <= MDOUT005;
        8'd6 : MDOUT <= MDOUT006;
        8'd7 : MDOUT <= MDOUT007;
        8'd8 : MDOUT <= MDOUT008;
        8'd9 : MDOUT <= MDOUT009;
        8'd10 : MDOUT <= MDOUT010;
        8'd11 : MDOUT <= MDOUT011;
        8'd12 : MDOUT <= MDOUT012;
        8'd13 : MDOUT <= MDOUT013;
        8'd14 : MDOUT <= MDOUT014;
        8'd15 : MDOUT <= MDOUT015;
        8'd16 : MDOUT <= MDOUT016;
        8'd17 : MDOUT <= MDOUT017;
        8'd18 : MDOUT <= MDOUT018;
        8'd19 : MDOUT <= MDOUT019;
        8'd20 : MDOUT <= MDOUT020;
      endcase // casex(NID)
   end

endmodule // nrm
