/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
`include "dunit.vh"

module cni_tmod(CLK, RST,
                IREQ, IRDY, DIN,
                AWE, ADDR,
                REQ, ACK, DOUT
                );

   input CLK, RST;

   input  [1:0] IREQ;
   output       IRDY;
   input [31:0] DIN;

   output        AWE;
   output [19:0] ADDR;

   output REQ;
   input  ACK;
   output [127:0] DOUT;

   reg [2:0]  STATE;
   reg [31:0] DATA0, DATA1, DATA2, DATA3;
   reg [9:0]  RIN;
   
   reg        PFLAG; // Pre calculation

   assign     IRDY = ~PFLAG | ACK;
   assign     AWE  = ((IREQ == 2'b01 & IRDY) | (STATE == 3'b001)) ? `WRITE : `READ;
   assign     ADDR = DIN[19:0];

   assign     REQ  = ((STATE == 3'b100) | PFLAG) & ~ACK;
//   assign     DOUT = (ACK) ? {DATA0, DATA3, DATA2, DATA1} : 128'b0;
   assign     DOUT = (ACK) ? {DATA1, DATA3, DATA2, DATA0} : 128'b0;
   // need  RID, TAU,      TOLD,  AOLD,  ANEW
   // input RIN, DATA1,    DATA3, DATA2, DATA0
   //      (RIN, IPQ_ROOT, olda,  newa,  oldtau)

   always@(posedge CLK) begin
      if(RST) begin
         STATE <= 2'b0;
         PFLAG <= `DISABLE;
      end
      else begin
         casex(STATE)
           3'b000 : begin
              if((~PFLAG | ACK) & (IREQ == 2'b01)) STATE <= 3'b001;
              if(ACK) PFLAG <= `DISABLE;
           end
           3'b001 : begin
              RIN   <= DIN[9:0];
              STATE <= 3'b101;
           end
           3'b101 : begin
              DATA0 <= DIN;
              STATE <= 3'b010;
           end
           3'b010 : begin
              DATA1 <= DIN;
              STATE <= 3'b011;
           end
           3'b011 : begin
              DATA2 <= DIN;
              STATE <= 3'b100;
           end
           3'b100 : begin
              DATA3 <= DIN;
              PFLAG <= `ENABLE;
              STATE <= 3'b000;
           end
         endcase // casex(STATE)
      end
   end

endmodule // cni
