/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module tcal_core(CLK, RST,
                 SET,
                 RNDIN,
                 REQ,
                 DIN,
                 DOUT);
   
   input  CLK, RST;
   input  SET;
   input [31:0] RNDIN;
   input  REQ;
   input  [63:0] DIN;
   output [31:0]  DOUT;

   wire [31:0] fdiv_a, fdiv_b, fdiv_q;
   wire [31:0] rangen_dout;
   reg [31:0]  dinb;
   wire [31:0] fa_a, fa_b, fa_q;

   reg [32*29 - 1 : 0] DATA;
   
   always@(posedge CLK) begin
      dinb <= DIN[31:0];
      DATA <= {DATA[32*28-1:0], DIN[63:32]};
   end
   
   assign fdiv_a = rangen_dout;
   assign fdiv_b = dinb;
   assign fa_a   = fdiv_q;
   assign fa_b   = DATA[32*29-1:32*28];

   rangen rangen(.CLK(CLK), .RST(RST),
                 .SET(SET),
                 .DIN(RNDIN),
                 .REQ(REQ),
                 .DOUT(rangen_dout));

   fdiv fdiv(.clk(CLK),
             .a(fdiv_a),
             .b(fdiv_b),
             .result(fdiv_q));

   fadd_hs_fu fa(.clk(CLK),
                 .a(fa_a),
                 .b(fa_b),
                 .result(fa_q));

   assign DOUT = fa_q;

endmodule // tcal_core

