/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module cni_tcal(CLK, RST,
                IREQ, IRDY, DIN,
                AWE, ADDR,
                REQ, ACK, DOUT
                );

   input CLK, RST;

   input  [1:0] IREQ;
   output       IRDY;
   input [31:0] DIN;

   output       AWE;
   output [19:0] ADDR;

   output REQ;
   input  ACK;
   output [63:0] DOUT;

   reg [1:0]     STATE;
   reg [9:0]     DADDR;
   reg [31:0]    DATA1, DATA2;
   
   reg    PFLAG; // Pre calculation

   assign IRDY = ~PFLAG | ACK;
   assign AWE  = ((IREQ == 2'b01 & IRDY) | (STATE == 2'b01)) ? `WRITE : `READ;
//   assign ADDR = (STATE == 2'b01) ? {DIN[31], 9'b0, DIN[9:0]} :  DIN[19:0];
   assign ADDR = DIN[19:0];
   
   assign REQ  = ((STATE == 2'b11) | PFLAG) & ~ACK;
   assign DOUT = (ACK) ? {DATA2, DATA1} : 64'b0;

   always@(posedge CLK) begin
      if(RST) begin
         STATE <= 2'b0;
         PFLAG <= `DISABLE;
      end
      else begin
         casex(STATE)
           2'b00 : begin
              if((~PFLAG | (PFLAG & ACK)) & (IREQ == 2'b01)) STATE <= 2'b01;
              if(ACK) PFLAG <= `DISABLE;
           end
           2'b01 : begin
              STATE <= 2'b10;
           end
           2'b10 : begin
              DATA1 <= DIN;
              STATE <= 2'b11;
           end
           2'b11 : begin
              STATE <= 2'b00;
              PFLAG <= `ENABLE;
              DATA2 <= DIN;
           end
         endcase // casex(STATE)
      end
   end

endmodule // cni
