/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module rangen(CLK,
              RST,
              SET,
              DIN,
              REQ,
              DOUT);
   
   input CLK;
   input SET;
   input RST;
   input [31:0] DIN;
   input        REQ;
   output [31:0] DOUT;

   wire [31:0]   rand_dout;
   
   reg RE;
   
   lfsr lfsr(.CLK(CLK),
             .SET(SET),
             .RE(RE),
             .DIN(DIN),
             .DOUT(rand_dout));

   wire [31:0] fa_a, fa_b, fa_q;
   wire [31:0] fd_a, fd_b, fd_q;
   wire [31:0] sln_in, sln_out;

   wire           fifo_we,  fifo_re;
   wire           fifo_emp, fifo_full, fifo_rdy;
   wire [31:0]    fifo_din, fifo_dout;

   reg [109:0]     data_sr;

   assign         fifo_we  = data_sr[109];
   assign         fifo_re  = REQ;
   assign         fifo_din = sln_out;
   
   assign fa_a = {1'b0, 8'h7F, rand_dout[22:0]};
   assign fa_b = 32'hBF800000;

   assign fd_a = 32'h3F800000;
   assign fd_b = fa_q;

   assign sln_in = fd_q;
   
   fadd_hs_fu fa1(.clk(CLK),
                  .a(fa_a),
                  .b(fa_b),
                  .result(fa_q));

   fdiv fdiv(.clk(CLK),
             .a(fd_a),
             .b(fd_b),
             .result(fd_q));

   sln sln(.CLK(CLK),
           .IN(sln_in),
           .OUT(sln_out));


   always@(posedge CLK) begin
      if(RST) begin
         RE      <= `DISABLE;
         data_sr <= 110'b0;
      end
      else begin
         if(fifo_rdy) RE <= `DISABLE;
         else         RE <= `ENABLE;
         data_sr <= {data_sr[108:0], RE & (SET | REQ)};
      end
   end

   fifo32x9_bi fifo(.clk(CLK),
                    .rst(RST),
                    .rd_en(fifo_re),
                    .wr_en(fifo_we),
                    .full(fifo_full),
                    .empty(fifo_emp),
                    .prog_full(fifo_rdy),
                    .din(fifo_din),
                    .dout(fifo_dout));
   
   assign DOUT = fifo_dout;
   
endmodule // rangen
