/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

module lfsr(CLK,
            SET,
            RE,
            DIN,
            DOUT
            );

   input CLK;
   input [31:0] DIN;
   input        SET;
   input RE;
   output [31:0] DOUT;

   reg [166:0]   ran;

   assign        DOUT = ran[166:135];

   always@(posedge CLK) begin
      if(SET) begin
         ran <= {ran[134:0], DIN};
      end
      else if(RE) begin
         ran <= {ran[165:0], ran[166] ^ ran[0]};
      end
   end

endmodule // lfsr
