/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
`include "dunit.vh"

module cunit_updt(CLK,
                  UWE, UDADR, UDDIN,
                  IREQ0, IRDY0, DIN0,
                  OREQ0, ORDY0, DOUT0,
                  RST);

   input          CLK, RST;
   input [1:0]    UWE;
   input [10:0]   UDADR;
   input [31:0]   UDDIN;
   input [1:0]    IREQ0;
   output         IRDY0;
   input [31:0]   DIN0;
   output [1:0]   OREQ0;
   input          ORDY0;
   output [31:0]  DOUT0;

   wire           HOLD;

   wire          REQ, ACK, AWE, DWE, CRDY, OST, OUT;
   wire [31:0]   CDO0;
   wire [19:0]   ADDR0;
   wire [31:0]   CORE_DIN;
   wire [31:0]   CORE_DOUT;

   assign         CORE_DIN = (ACK) ? CDO0 :
                             32'b0;

   updt_core updt(.CLK(CLK), .RST(RST),
                  .UWE(UWE), .UDADR(UDADR), .UDDIN(UDDIN),
                  .REQ(ACK),
                  .HOLD(HOLD),
                  .DIN(CORE_DIN),
                  .DOUT(CORE_DOUT));

   sr1x1_wh sr(.CLK(CLK), .RST(RST), .HOLD(HOLD), .DIN(ACK), .DOUT(DWE));

   cni_updt cni0(.CLK(CLK), .RST(RST),
                 .IREQ(IREQ0), .IRDY(IRDY0), .DIN(DIN0),
                 .AWE(AWE), .ADDR(ADDR0),
                 .REQ(REQ), .ACK(ACK), .DOUT(CDO0));

   cno_updt cno0(.CLK(CLK), .RST(RST),
                 .AWE(AWE), .ADDR(ADDR0),
                 .DWE(DWE), .DIN(CORE_DOUT),
                 .CRDY(CRDY), .OST(OST),
                 .OREQ(OREQ0), .ORDY(ORDY0), .DOUT(DOUT0),
                 .HEADER(`OP_UPDT));


   carb1_hold carb1(.CLK(CLK), .RST(RST),
                    .REQ(REQ), .ACK(ACK),
                    .OST(OST),
                    .CRDY(CRDY), .HOLD(HOLD));

endmodule
