/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module demux16(CLK, 
              IREQ, IRDY, DIN, DOUT,
              OREQ0, ORDY0,
              OREQ1, ORDY1,
              OREQ2, ORDY2,
              OREQ3, ORDY3,
              OREQ4, ORDY4,
              OREQ5, ORDY5,
              OREQ6, ORDY6,
              OREQ7, ORDY7,
              OREQ8, ORDY8,
              OREQ9, ORDY9,
              OREQ10, ORDY10,
              OREQ11, ORDY11,
              OREQ12, ORDY12,
              OREQ13, ORDY13,
              OREQ14, ORDY14,
              OREQ15, ORDY15,
              RST);
   input CLK;
   input RST;

   input [1:0]    IREQ;
   output         IRDY;
   input  [31:0]  DIN;
   output [31:0]  DOUT;

   output [1:0]   OREQ0, OREQ1, OREQ2, OREQ3, OREQ4, OREQ5, OREQ6, OREQ7, OREQ8, OREQ9, OREQ10, OREQ11, OREQ12, OREQ13, OREQ14, OREQ15;
   input          ORDY0, ORDY1, ORDY2, ORDY3, ORDY4, ORDY5, ORDY6, ORDY7, ORDY8, ORDY9, ORDY10, ORDY11, ORDY12, ORDY13, ORDY14, ORDY15;

   reg       STATE;
   wire      ORDY;
   reg [15:0] ENC;
   reg [15:0] PND;

   wire FIFO_WE, FIFO_RE;
   wire FIFO_FULL;
   wire [`FIFO_WIDTH - 1 : 0] FIFO_DIN, FIFO_DOUT;

   assign OREQ0 = (STATE & ENC[0]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ1 = (STATE & ENC[1]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ2 = (STATE & ENC[2]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ3 = (STATE & ENC[3]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ4 = (STATE & ENC[4]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ5 = (STATE & ENC[5]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ6 = (STATE & ENC[6]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ7 = (STATE & ENC[7]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ8 = (STATE & ENC[8]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ9 = (STATE & ENC[9]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ10 = (STATE & ENC[10]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ11 = (STATE & ENC[11]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ12 = (STATE & ENC[12]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ13 = (STATE & ENC[13]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ14 = (STATE & ENC[14]) ? FIFO_DOUT[33:32] : 2'b00;
   assign OREQ15 = (STATE & ENC[15]) ? FIFO_DOUT[33:32] : 2'b00;

   assign ORDY = (ENC[0]) ? ORDY0 :
                 (ENC[1]) ? ORDY1 :
                 (ENC[2]) ? ORDY2 :
                 (ENC[3]) ? ORDY3 :
                 (ENC[4]) ? ORDY4 :
                 (ENC[5]) ? ORDY5 :
                 (ENC[6]) ? ORDY6 :
                 (ENC[7]) ? ORDY7 :
                 (ENC[8]) ? ORDY8 :
                 (ENC[9]) ? ORDY9 :
                 (ENC[10]) ? ORDY10 :
                 (ENC[11]) ? ORDY11 :
                 (ENC[12]) ? ORDY12 :
                 (ENC[13]) ? ORDY13 :
                 (ENC[14]) ? ORDY14 :
                 (ENC[15]) ? ORDY15 : `DISABLE;

   assign IRDY = ~FIFO_FULL;
   assign FIFO_WE  = |IREQ & ~FIFO_FULL;
   assign FIFO_DIN = {IREQ, DIN};
   assign FIFO_RE  = STATE & ORDY;

   bus_fifo fifo(.CLK(CLK), .RST(RST),
                 .WE(FIFO_WE),
                 .RE(FIFO_RE),
                 .FULL(FIFO_FULL),
                 .DIN(FIFO_DIN),
                 .DOUT(FIFO_DOUT));

   function [15:0] encode;
      input [3:0] addr;
      begin
         casex(addr)
           4'b0000 : encode = 16'b0000000000000001;
           4'b0001 : encode = 16'b0000000000000010;
           4'b0010 : encode = 16'b0000000000000100;
           4'b0011 : encode = 16'b0000000000001000;
           4'b0100 : encode = 16'b0000000000010000;
           4'b0101 : encode = 16'b0000000000100000;
           4'b0110 : encode = 16'b0000000001000000;
           4'b0111 : encode = 16'b0000000010000000;
           4'b1000 : encode = 16'b0000000100000000;
           4'b1001 : encode = 16'b0000001000000000;
           4'b1010 : encode = 16'b0000010000000000;
           4'b1011 : encode = 16'b0000100000000000;
           4'b1100 : encode = 16'b0001000000000000;
           4'b1101 : encode = 16'b0010000000000000;
           4'b1110 : encode = 16'b0100000000000000;
           4'b1111 : encode = 16'b1000000000000000;
           default : encode = 16'b0;
         endcase // casex(addr)
      end
   endfunction // encode

   assign DOUT = (FIFO_DOUT[33:32] == 2'b01) ? {FIFO_DOUT[31:20], FIFO_DOUT[15:0], FIFO_DOUT[19:16]} : FIFO_DOUT[31:0];

   always@(posedge CLK) begin
      if(RST) begin
         STATE <= 1'b0;
         ENC   <= 16'b0;
         PND   <= 16'b0;
      end
      else begin
         if(STATE & IREQ == 2'b01) PND <= encode(DIN[19:16]);
         if(~STATE) begin
            if(|IREQ) begin
               STATE <= 1'b1;
               ENC   <= encode(DIN[19:16]);
            end
         end
         else begin
            if(FIFO_DOUT[33:32] == 2'b10 & ORDY) begin
               if(IREQ == 2'b01) ENC   <= encode(DIN[19:16]);
               else if(IREQ[1])  ENC   <= PND;
               else              STATE <= 1'b0;
            end
         end
      end
   end
endmodule // demux16
