
module fsub_hs_fu
  (
    input clk,
    input [31:0] a, b,
    output reg [31:0] result );

   wire [31:0] 	  o;

   fsub_hs_fu_core core
     (
      .clk(clk),
      .a(a),
      .b(b),
      .result(o)
      );
   
   always @ (posedge clk)
     result <= o;

endmodule // fsub_hs_fu

module fadd_hs_fu
  (
    input clk,
    input [31:0] a, b,
    output reg [31:0] result );

   wire [31:0] 	  o;

   fadd_hs_fu_core core
     (
      .clk(clk),
      .a(a),
      .b(b),
      .result(o)
      );
   
   always @ (posedge clk)
     result <= o;

endmodule // fadd_hs_fu




