/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

module sr1x48(CLK, RST, DIN, DOUT);

   input CLK, RST;
   input  [0:0] DIN;
   output [0:0] DOUT;

   reg [1*48 - 1 : 0]    DATA;

   assign       DOUT = DATA[1*48 - 1 : 1*47];

   always@(posedge CLK) begin
      DATA <= {DATA[1*47-1:0],DIN};
   end

endmodule // sr1x48
