/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module no20(CLK, RST,
           SEL,
           PURGE,
           DIN0, DIN1, DIN2, DIN3, DIN4, DIN5, DIN6, DIN7, DIN8, DIN9, DIN10, DIN11, DIN12, DIN13, DIN14, DIN15, DIN16, DIN17, DIN18, DIN19,
           OREQ,ORDY,
           DOUT);

   input CLK;
   input RST;

   output PURGE;

   input [19:0] SEL;
   output [1:0] OREQ;
   input        ORDY;
   input  [`FIFO_WIDTH - 1 : 0]  DIN0,  DIN1,  DIN2,  DIN3,  DIN4,  DIN5,  DIN6,  DIN7,  DIN8,  DIN9,  DIN10,  DIN11,  DIN12,  DIN13,  DIN14,  DIN15,  DIN16,  DIN17,  DIN18,  DIN19;
   output [`DATA_WIDTH - 1 : 0] DOUT;

   assign    PURGE = (OREQ == 2'b10) & ORDY;

   assign    OREQ = (SEL[0]) ? DIN0[33:32] :
                      (SEL[1]) ? DIN1[33:32] :
                      (SEL[2]) ? DIN2[33:32] :
                      (SEL[3]) ? DIN3[33:32] :
                      (SEL[4]) ? DIN4[33:32] :
                      (SEL[5]) ? DIN5[33:32] :
                      (SEL[6]) ? DIN6[33:32] :
                      (SEL[7]) ? DIN7[33:32] :
                      (SEL[8]) ? DIN8[33:32] :
                      (SEL[9]) ? DIN9[33:32] :
                      (SEL[10]) ? DIN10[33:32] :
                      (SEL[11]) ? DIN11[33:32] :
                      (SEL[12]) ? DIN12[33:32] :
                      (SEL[13]) ? DIN13[33:32] :
                      (SEL[14]) ? DIN14[33:32] :
                      (SEL[15]) ? DIN15[33:32] :
                      (SEL[16]) ? DIN16[33:32] :
                      (SEL[17]) ? DIN17[33:32] :
                      (SEL[18]) ? DIN18[33:32] :
                      (SEL[19]) ? DIN19[33:32] :
                                 2'b0;

   assign    DOUT = (SEL[0]) ? DIN0[`DATA_WIDTH - 1:0] :
                    (SEL[1]) ? DIN1[`DATA_WIDTH - 1:0] :
                    (SEL[2]) ? DIN2[`DATA_WIDTH - 1:0] :
                    (SEL[3]) ? DIN3[`DATA_WIDTH - 1:0] :
                    (SEL[4]) ? DIN4[`DATA_WIDTH - 1:0] :
                    (SEL[5]) ? DIN5[`DATA_WIDTH - 1:0] :
                    (SEL[6]) ? DIN6[`DATA_WIDTH - 1:0] :
                    (SEL[7]) ? DIN7[`DATA_WIDTH - 1:0] :
                    (SEL[8]) ? DIN8[`DATA_WIDTH - 1:0] :
                    (SEL[9]) ? DIN9[`DATA_WIDTH - 1:0] :
                    (SEL[10]) ? DIN10[`DATA_WIDTH - 1:0] :
                    (SEL[11]) ? DIN11[`DATA_WIDTH - 1:0] :
                    (SEL[12]) ? DIN12[`DATA_WIDTH - 1:0] :
                    (SEL[13]) ? DIN13[`DATA_WIDTH - 1:0] :
                    (SEL[14]) ? DIN14[`DATA_WIDTH - 1:0] :
                    (SEL[15]) ? DIN15[`DATA_WIDTH - 1:0] :
                    (SEL[16]) ? DIN16[`DATA_WIDTH - 1:0] :
                    (SEL[17]) ? DIN17[`DATA_WIDTH - 1:0] :
                    (SEL[18]) ? DIN18[`DATA_WIDTH - 1:0] :
                    (SEL[19]) ? DIN19[`DATA_WIDTH - 1:0] :
                               32'b0;

endmodule // no20
