/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module bus_fifo(CLK, RST,
                WE,  RE,
                FULL,
                DIN, DOUT);
   
   input CLK, RST;
   input WE, RE;
   output                       FULL;
   input  [`FIFO_WIDTH - 1 : 0] DIN;
   output [`FIFO_WIDTH - 1 : 0] DOUT;

   reg                          WADR, RADR;
   reg                          FULL, EMP;

   reg [`FIFO_WIDTH - 1 : 0]    DATA[0:1];

   assign                       DOUT = DATA[RADR];
   
   always@(posedge CLK) begin
      if(RST) begin
         DATA[0] <= `FIFO_WIDTH'b0;
         WADR    <= 1'b0;
         RADR    <= 1'b0;
         FULL    <= 1'b0;
         EMP     <= 1'b1;
      end
      else begin
         if(WE & ~FULL) begin
            DATA[WADR] <= DIN;
            WADR       <= ~WADR;
         end

         if(RE & ~EMP) begin
            RADR <= ~RADR;
            DATA[RADR] <= `FIFO_WIDTH'b0;
         end
         
         if(WADR == ~RADR & WE & ~RE) FULL <= 1'b1;
         else if(FULL & RE & ~WE)     FULL <= 1'b0;

         if(WE & ~FULL & ~RE)              EMP <= 1'b0;
         else if(WADR == ~RADR & ~WE & RE) EMP <= 1'b1;
      end
   end

endmodule // bus_fifo
