/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"

module bus20(CLK, RST,
            IREQ0, IRDY0, DIN0,
            IREQ1, IRDY1, DIN1,
            IREQ2, IRDY2, DIN2,
            IREQ3, IRDY3, DIN3,
            IREQ4, IRDY4, DIN4,
            IREQ5, IRDY5, DIN5,
            IREQ6, IRDY6, DIN6,
            IREQ7, IRDY7, DIN7,
            IREQ8, IRDY8, DIN8,
            IREQ9, IRDY9, DIN9,
            IREQ10, IRDY10, DIN10,
            IREQ11, IRDY11, DIN11,
            IREQ12, IRDY12, DIN12,
            IREQ13, IRDY13, DIN13,
            IREQ14, IRDY14, DIN14,
            IREQ15, IRDY15, DIN15,
            IREQ16, IRDY16, DIN16,
            IREQ17, IRDY17, DIN17,
            IREQ18, IRDY18, DIN18,
            IREQ19, IRDY19, DIN19,
            OREQ, ORDY, DOUT
            );

   input  CLK,RST;

   input [1:0] IREQ0;
   output      IRDY0;
   input [`DATA_WIDTH - 1 : 0] DIN0;

   input [1:0] IREQ1;
   output      IRDY1;
   input [`DATA_WIDTH - 1 : 0] DIN1;

   input [1:0] IREQ2;
   output      IRDY2;
   input [`DATA_WIDTH - 1 : 0] DIN2;

   input [1:0] IREQ3;
   output      IRDY3;
   input [`DATA_WIDTH - 1 : 0] DIN3;

   input [1:0] IREQ4;
   output      IRDY4;
   input [`DATA_WIDTH - 1 : 0] DIN4;

   input [1:0] IREQ5;
   output      IRDY5;
   input [`DATA_WIDTH - 1 : 0] DIN5;

   input [1:0] IREQ6;
   output      IRDY6;
   input [`DATA_WIDTH - 1 : 0] DIN6;

   input [1:0] IREQ7;
   output      IRDY7;
   input [`DATA_WIDTH - 1 : 0] DIN7;

   input [1:0] IREQ8;
   output      IRDY8;
   input [`DATA_WIDTH - 1 : 0] DIN8;

   input [1:0] IREQ9;
   output      IRDY9;
   input [`DATA_WIDTH - 1 : 0] DIN9;

   input [1:0] IREQ10;
   output      IRDY10;
   input [`DATA_WIDTH - 1 : 0] DIN10;

   input [1:0] IREQ11;
   output      IRDY11;
   input [`DATA_WIDTH - 1 : 0] DIN11;

   input [1:0] IREQ12;
   output      IRDY12;
   input [`DATA_WIDTH - 1 : 0] DIN12;

   input [1:0] IREQ13;
   output      IRDY13;
   input [`DATA_WIDTH - 1 : 0] DIN13;

   input [1:0] IREQ14;
   output      IRDY14;
   input [`DATA_WIDTH - 1 : 0] DIN14;

   input [1:0] IREQ15;
   output      IRDY15;
   input [`DATA_WIDTH - 1 : 0] DIN15;

   input [1:0] IREQ16;
   output      IRDY16;
   input [`DATA_WIDTH - 1 : 0] DIN16;

   input [1:0] IREQ17;
   output      IRDY17;
   input [`DATA_WIDTH - 1 : 0] DIN17;

   input [1:0] IREQ18;
   output      IRDY18;
   input [`DATA_WIDTH - 1 : 0] DIN18;

   input [1:0] IREQ19;
   output      IRDY19;
   input [`DATA_WIDTH - 1 : 0] DIN19;



   output [1:0] OREQ;
   input        ORDY;
   output [`DATA_WIDTH - 1 : 0] DOUT;

   wire [`FIFO_WIDTH - 1 : 0]   DOUT0, DOUT1, DOUT2, DOUT3, DOUT4, DOUT5, DOUT6, DOUT7, DOUT8, DOUT9, DOUT10, DOUT11, DOUT12, DOUT13, DOUT14, DOUT15, DOUT16, DOUT17, DOUT18, DOUT19;


   wire       PURGE;
   wire [19:0] SEL, AREQ;

   ni ni0(.CLK(CLK), .RST(RST),
          .IREQ(IREQ0), .IRDY(IRDY0), .DIN(DIN0),
          .RE(SEL[0] & ORDY),
          .REQ(AREQ[0]),
          .DOUT(DOUT0));

   ni ni1(.CLK(CLK), .RST(RST),
          .IREQ(IREQ1), .IRDY(IRDY1), .DIN(DIN1),
          .RE(SEL[1] & ORDY),
          .REQ(AREQ[1]),
          .DOUT(DOUT1));

   ni ni2(.CLK(CLK), .RST(RST),
          .IREQ(IREQ2), .IRDY(IRDY2), .DIN(DIN2),
          .RE(SEL[2] & ORDY),
          .REQ(AREQ[2]),
          .DOUT(DOUT2));

   ni ni3(.CLK(CLK), .RST(RST),
          .IREQ(IREQ3), .IRDY(IRDY3), .DIN(DIN3),
          .RE(SEL[3] & ORDY),
          .REQ(AREQ[3]),
          .DOUT(DOUT3));

   ni ni4(.CLK(CLK), .RST(RST),
          .IREQ(IREQ4), .IRDY(IRDY4), .DIN(DIN4),
          .RE(SEL[4] & ORDY),
          .REQ(AREQ[4]),
          .DOUT(DOUT4));

   ni ni5(.CLK(CLK), .RST(RST),
          .IREQ(IREQ5), .IRDY(IRDY5), .DIN(DIN5),
          .RE(SEL[5] & ORDY),
          .REQ(AREQ[5]),
          .DOUT(DOUT5));

   ni ni6(.CLK(CLK), .RST(RST),
          .IREQ(IREQ6), .IRDY(IRDY6), .DIN(DIN6),
          .RE(SEL[6] & ORDY),
          .REQ(AREQ[6]),
          .DOUT(DOUT6));

   ni ni7(.CLK(CLK), .RST(RST),
          .IREQ(IREQ7), .IRDY(IRDY7), .DIN(DIN7),
          .RE(SEL[7] & ORDY),
          .REQ(AREQ[7]),
          .DOUT(DOUT7));

   ni ni8(.CLK(CLK), .RST(RST),
          .IREQ(IREQ8), .IRDY(IRDY8), .DIN(DIN8),
          .RE(SEL[8] & ORDY),
          .REQ(AREQ[8]),
          .DOUT(DOUT8));

   ni ni9(.CLK(CLK), .RST(RST),
          .IREQ(IREQ9), .IRDY(IRDY9), .DIN(DIN9),
          .RE(SEL[9] & ORDY),
          .REQ(AREQ[9]),
          .DOUT(DOUT9));

   ni ni10(.CLK(CLK), .RST(RST),
          .IREQ(IREQ10), .IRDY(IRDY10), .DIN(DIN10),
          .RE(SEL[10] & ORDY),
          .REQ(AREQ[10]),
          .DOUT(DOUT10));

   ni ni11(.CLK(CLK), .RST(RST),
          .IREQ(IREQ11), .IRDY(IRDY11), .DIN(DIN11),
          .RE(SEL[11] & ORDY),
          .REQ(AREQ[11]),
          .DOUT(DOUT11));

   ni ni12(.CLK(CLK), .RST(RST),
          .IREQ(IREQ12), .IRDY(IRDY12), .DIN(DIN12),
          .RE(SEL[12] & ORDY),
          .REQ(AREQ[12]),
          .DOUT(DOUT12));

   ni ni13(.CLK(CLK), .RST(RST),
          .IREQ(IREQ13), .IRDY(IRDY13), .DIN(DIN13),
          .RE(SEL[13] & ORDY),
          .REQ(AREQ[13]),
          .DOUT(DOUT13));

   ni ni14(.CLK(CLK), .RST(RST),
          .IREQ(IREQ14), .IRDY(IRDY14), .DIN(DIN14),
          .RE(SEL[14] & ORDY),
          .REQ(AREQ[14]),
          .DOUT(DOUT14));

   ni ni15(.CLK(CLK), .RST(RST),
          .IREQ(IREQ15), .IRDY(IRDY15), .DIN(DIN15),
          .RE(SEL[15] & ORDY),
          .REQ(AREQ[15]),
          .DOUT(DOUT15));

   ni ni16(.CLK(CLK), .RST(RST),
          .IREQ(IREQ16), .IRDY(IRDY16), .DIN(DIN16),
          .RE(SEL[16] & ORDY),
          .REQ(AREQ[16]),
          .DOUT(DOUT16));

   ni ni17(.CLK(CLK), .RST(RST),
          .IREQ(IREQ17), .IRDY(IRDY17), .DIN(DIN17),
          .RE(SEL[17] & ORDY),
          .REQ(AREQ[17]),
          .DOUT(DOUT17));

   ni ni18(.CLK(CLK), .RST(RST),
          .IREQ(IREQ18), .IRDY(IRDY18), .DIN(DIN18),
          .RE(SEL[18] & ORDY),
          .REQ(AREQ[18]),
          .DOUT(DOUT18));

   ni ni19(.CLK(CLK), .RST(RST),
          .IREQ(IREQ19), .IRDY(IRDY19), .DIN(DIN19),
          .RE(SEL[19] & ORDY),
          .REQ(AREQ[19]),
          .DOUT(DOUT19));


   arbiter20 arbiter(.CLK(CLK), .RST(RST),
                    .REQ(AREQ),
                    .SEL(SEL),
                    .PURGE(PURGE));

   no20 no(.CLK(CLK), .RST(RST),
          .SEL(SEL),
          .PURGE(PURGE),
          .DIN0(DOUT0), .DIN1(DOUT1), .DIN2(DOUT2), .DIN3(DOUT3), .DIN4(DOUT4), .DIN5(DOUT5), .DIN6(DOUT6), .DIN7(DOUT7), .DIN8(DOUT8), .DIN9(DOUT9), .DIN10(DOUT10), .DIN11(DOUT11), .DIN12(DOUT12), .DIN13(DOUT13), .DIN14(DOUT14), .DIN15(DOUT15), .DIN16(DOUT16), .DIN17(DOUT17), .DIN18(DOUT18), .DIN19(DOUT19),
          .OREQ(OREQ),  .ORDY(ORDY),  .DOUT(DOUT));

endmodule // bus20
