/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
module arbiter8(CLK, RST,
                REQ,
                SEL,
                PURGE);

   input CLK, RST;
   input  [7 : 0]  REQ;
   output [7 : 0]  SEL;
   input         PURGE;
   
   reg [7 : 0]     PRIORITY;
   reg [7 : 0]     SEL;
   reg           STATE;

   function [7:0] SEL_REQ;
      input [7:0] PRI;
      input [7:0] IREQ;
      begin
         casex(PRI)
           8'b00000001 : begin
             casex(IREQ)
               8'bxxxxxxx1 : SEL_REQ = 8'b00000001;
               8'bxxxxxx10 : SEL_REQ = 8'b00000010;
               8'bxxxxx100 : SEL_REQ = 8'b00000100;
               8'bxxxx1000 : SEL_REQ = 8'b00001000;
               8'bxxx10000 : SEL_REQ = 8'b00010000;
               8'bxx100000 : SEL_REQ = 8'b00100000;
               8'bx1000000 : SEL_REQ = 8'b01000000;
               8'b10000000 : SEL_REQ = 8'b10000000;
               default : SEL_REQ = 8'b0;
             endcase
           end
           8'b00000010 : begin
             casex(IREQ)
               8'bxxxxxx1x : SEL_REQ = 8'b00000010;
               8'bxxxxx10x : SEL_REQ = 8'b00000100;
               8'bxxxx100x : SEL_REQ = 8'b00001000;
               8'bxxx1000x : SEL_REQ = 8'b00010000;
               8'bxx10000x : SEL_REQ = 8'b00100000;
               8'bx100000x : SEL_REQ = 8'b01000000;
               8'b1000000x : SEL_REQ = 8'b10000000;
               8'b00000001 : SEL_REQ = 8'b00000001;
               default : SEL_REQ = 8'b0;
             endcase
           end
           8'b00000100 : begin
             casex(IREQ)
               8'bxxxxx1xx : SEL_REQ = 8'b00000100;
               8'bxxxx10xx : SEL_REQ = 8'b00001000;
               8'bxxx100xx : SEL_REQ = 8'b00010000;
               8'bxx1000xx : SEL_REQ = 8'b00100000;
               8'bx10000xx : SEL_REQ = 8'b01000000;
               8'b100000xx : SEL_REQ = 8'b10000000;
               8'b000000x1 : SEL_REQ = 8'b00000001;
               8'b00000010 : SEL_REQ = 8'b00000010;
               default : SEL_REQ = 8'b0;
             endcase
           end
           8'b00001000 : begin
             casex(IREQ)
               8'bxxxx1xxx : SEL_REQ = 8'b00001000;
               8'bxxx10xxx : SEL_REQ = 8'b00010000;
               8'bxx100xxx : SEL_REQ = 8'b00100000;
               8'bx1000xxx : SEL_REQ = 8'b01000000;
               8'b10000xxx : SEL_REQ = 8'b10000000;
               8'b00000xx1 : SEL_REQ = 8'b00000001;
               8'b00000x10 : SEL_REQ = 8'b00000010;
               8'b00000100 : SEL_REQ = 8'b00000100;
               default : SEL_REQ = 8'b0;
             endcase
           end
           8'b00010000 : begin
             casex(IREQ)
               8'bxxx1xxxx : SEL_REQ = 8'b00010000;
               8'bxx10xxxx : SEL_REQ = 8'b00100000;
               8'bx100xxxx : SEL_REQ = 8'b01000000;
               8'b1000xxxx : SEL_REQ = 8'b10000000;
               8'b0000xxx1 : SEL_REQ = 8'b00000001;
               8'b0000xx10 : SEL_REQ = 8'b00000010;
               8'b0000x100 : SEL_REQ = 8'b00000100;
               8'b00001000 : SEL_REQ = 8'b00001000;
               default : SEL_REQ = 8'b0;
             endcase
           end
           8'b00100000 : begin
             casex(IREQ)
               8'bxx1xxxxx : SEL_REQ = 8'b00100000;
               8'bx10xxxxx : SEL_REQ = 8'b01000000;
               8'b100xxxxx : SEL_REQ = 8'b10000000;
               8'b000xxxx1 : SEL_REQ = 8'b00000001;
               8'b000xxx10 : SEL_REQ = 8'b00000010;
               8'b000xx100 : SEL_REQ = 8'b00000100;
               8'b000x1000 : SEL_REQ = 8'b00001000;
               8'b00010000 : SEL_REQ = 8'b00010000;
               default : SEL_REQ = 8'b0;
             endcase
           end
           8'b01000000 : begin
             casex(IREQ)
               8'bx1xxxxxx : SEL_REQ = 8'b01000000;
               8'b10xxxxxx : SEL_REQ = 8'b10000000;
               8'b00xxxxx1 : SEL_REQ = 8'b00000001;
               8'b00xxxx10 : SEL_REQ = 8'b00000010;
               8'b00xxx100 : SEL_REQ = 8'b00000100;
               8'b00xx1000 : SEL_REQ = 8'b00001000;
               8'b00x10000 : SEL_REQ = 8'b00010000;
               8'b00100000 : SEL_REQ = 8'b00100000;
               default : SEL_REQ = 8'b0;
             endcase
           end
           8'b10000000 : begin
             casex(IREQ)
               8'b1xxxxxxx : SEL_REQ = 8'b10000000;
               8'b0xxxxxx1 : SEL_REQ = 8'b00000001;
               8'b0xxxxx10 : SEL_REQ = 8'b00000010;
               8'b0xxxx100 : SEL_REQ = 8'b00000100;
               8'b0xxx1000 : SEL_REQ = 8'b00001000;
               8'b0xx10000 : SEL_REQ = 8'b00010000;
               8'b0x100000 : SEL_REQ = 8'b00100000;
               8'b01000000 : SEL_REQ = 8'b01000000;
               default : SEL_REQ = 8'b0;
             endcase
           end
           default : SEL_REQ = 8'b0;
         endcase // casex(PRI)
      end
   endfunction // SEL_REQ


   always@(posedge CLK) begin
      if(RST) begin
         SEL      <= 8'b0;
         STATE    <= 1'b0;
         PRIORITY <= 8'b00000001;
      end
      else begin
         if(~STATE) begin
            if(|REQ) begin
               STATE <= 1'b1;
            end
            SEL <= SEL_REQ(PRIORITY, REQ);
         end
         else begin
            if(PURGE) begin
               if(~|REQ) begin
                  SEL   <= 8'b0;
                  STATE <= 1'b0;
               end
               else begin
                  SEL <= SEL_REQ(PRIORITY, REQ);
               end
               PRIORITY <= {PRIORITY[6:0], PRIORITY[7]};
            end
         end // else: !if(~STATE)
      end // else: !if(RST)
   end // always@ (posedge CLK)

endmodule // arbitor8
