/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
module arbiter4(CLK, RST,
                REQ,
                SEL,
                PURGE);

   input CLK, RST;
   input  [3 : 0]  REQ;
   output [3 : 0]  SEL;
   input         PURGE;
   
   reg [3 : 0]     PRIORITY;
   reg [3 : 0]     SEL;
   reg           STATE;

   function [3:0] SEL_REQ;
      input [3:0] PRI;
      input [3:0] IREQ;
      begin
         casex(PRI)
           4'b0001 : begin
             casex(IREQ)
               4'bxxx1 : SEL_REQ = 4'b0001;
               4'bxx10 : SEL_REQ = 4'b0010;
               4'bx100 : SEL_REQ = 4'b0100;
               4'b1000 : SEL_REQ = 4'b1000;
               default : SEL_REQ = 4'b0;
             endcase
           end
           4'b0010 : begin
             casex(IREQ)
               4'bxx1x : SEL_REQ = 4'b0010;
               4'bx10x : SEL_REQ = 4'b0100;
               4'b100x : SEL_REQ = 4'b1000;
               4'b0001 : SEL_REQ = 4'b0001;
               default : SEL_REQ = 4'b0;
             endcase
           end
           4'b0100 : begin
             casex(IREQ)
               4'bx1xx : SEL_REQ = 4'b0100;
               4'b10xx : SEL_REQ = 4'b1000;
               4'b00x1 : SEL_REQ = 4'b0001;
               4'b0010 : SEL_REQ = 4'b0010;
               default : SEL_REQ = 4'b0;
             endcase
           end
           4'b1000 : begin
             casex(IREQ)
               4'b1xxx : SEL_REQ = 4'b1000;
               4'b0xx1 : SEL_REQ = 4'b0001;
               4'b0x10 : SEL_REQ = 4'b0010;
               4'b0100 : SEL_REQ = 4'b0100;
               default : SEL_REQ = 4'b0;
             endcase
           end
           default : SEL_REQ = 4'b0;
         endcase // casex(PRI)
      end
   endfunction // SEL_REQ


   always@(posedge CLK) begin
      if(RST) begin
         SEL      <= 4'b0;
         STATE    <= 1'b0;
         PRIORITY <= 4'b0001;
      end
      else begin
         if(~STATE) begin
            if(|REQ) begin
               STATE <= 1'b1;
            end
            SEL <= SEL_REQ(PRIORITY, REQ);
         end
         else begin
            if(PURGE) begin
               if(~|REQ) begin
                  SEL   <= 4'b0;
                  STATE <= 1'b0;
               end
               else begin
                  SEL <= SEL_REQ(PRIORITY, REQ);
               end
               PRIORITY <= {PRIORITY[2:0], PRIORITY[3]};
            end
         end // else: !if(~STATE)
      end // else: !if(RST)
   end // always@ (posedge CLK)

endmodule // arbitor4
