/* NRM-FPGA: an NRM solver on an FPGA
 * 
 * Copyright (C) 2004-2009, Amano Lab., Keio University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

`include "define.vh"
module arbiter2(CLK, RST,
                REQ,
                SEL,
                PURGE);

   input CLK, RST;
   input  [1 : 0]  REQ;
   output [1 : 0]  SEL;
   input         PURGE;
   
   reg [1 : 0]     PRIORITY;
   reg [1 : 0]     SEL;
   reg           STATE;

   function [1:0] SEL_REQ;
      input [1:0] PRI;
      input [1:0] IREQ;
      begin
         casex(PRI)
           2'b01 : begin
             casex(IREQ)
               2'bx1 : SEL_REQ = 2'b01;
               2'b10 : SEL_REQ = 2'b10;
               default : SEL_REQ = 2'b0;
             endcase
           end
           2'b10 : begin
             casex(IREQ)
               2'b1x : SEL_REQ = 2'b10;
               2'b01 : SEL_REQ = 2'b01;
               default : SEL_REQ = 2'b0;
             endcase
           end
           default : SEL_REQ = 2'b0;
         endcase // casex(PRI)
      end
   endfunction // SEL_REQ


   always@(posedge CLK) begin
      if(RST) begin
         SEL      <= 2'b0;
         STATE    <= 1'b0;
         PRIORITY <= 2'b01;
      end
      else begin
         if(~STATE) begin
            if(|REQ) begin
               STATE <= 1'b1;
            end
            SEL <= SEL_REQ(PRIORITY, REQ);
         end
         else begin
            if(PURGE) begin
               if(~|REQ) begin
                  SEL   <= 2'b0;
                  STATE <= 1'b0;
               end
               else begin
                  SEL <= SEL_REQ(PRIORITY, REQ);
               end
               PRIORITY <= {PRIORITY[0:0], PRIORITY[1]};
            end
         end // else: !if(~STATE)
      end // else: !if(RST)
   end // always@ (posedge CLK)

endmodule // arbitor2
