#ifndef LIBSSA_H
#define LIBSSA_H

#include <stdio.h>

#include <sys/types.h>                  // Get int64_t etc
typedef u_int32_t u32;                  // Give them to less annoying names
typedef u_int64_t u64;                  // XXX: Need to ditch these defines:
#define FORMAT_U32 "%u"
#define FORMAT_U64 "%llu"

typedef struct {
  char* name;
} Participant;

typedef struct {
  u32 coefficient;
  Participant* participant;
} Term;

typedef struct {
  double propensity;
  Term** reactants;
  Term** products;
} SSAReaction;

typedef struct {
  Participant* participant;
  u64 population;
} InitialCondition;

typedef struct {
  SSAReaction** reactions;
  InitialCondition** initialConditions;
} Problem;

typedef struct {
  double t0,start,end,incr;
} Timeline;

Participant* participant(char* fmt,...);
Term* term(u32 coefficient,Participant* participant);
Term** termList(Term* t1,...);
SSAReaction* reaction(double propensity,Term** reactants,Term** products);

typedef struct {
  SSAReaction** list; 
  u32 size,num;
} ReactionList;

ReactionList* reactionList(void);
void reactionListAdd(ReactionList* l,SSAReaction* r);

typedef void Trajectory;

Trajectory* DirectLinear(Problem* p,Timeline* tl);

void trajectoryWritePts(FILE* f,Trajectory* traj);
void trajectoryWriteGnuplotScript(Trajectory* traj,Participant** ps,
                                  double xmin,double xmax,char* xl,char* yl);
void trajectoryPlot(Trajectory* traj,Participant** participants);
InitialCondition** trajectoryLastAsIC(Trajectory* traj);

#endif // LIBSSA_H
