/**
 * SBML-SSAlib bridge: a bridge library to connect SSAlib and SBML
 *
 * Copyright (C) 2004-2009, SBML-SSA Team, Keio/Seikei University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *                    
 * @file    SSALibUtil.cpp
 * @brief   Utiliti class using SSALib API
 * @author  Keio/Seikei SBML-SSA Team.
 */


#include "SSALibUtil.h"

void
SSALibUtil::printProblem(ostream& os, const SSAProblem *problem)
{
  // print reactions

  int num = 0;
  SSAReaction** reactions = problem->reactions;
  while (*reactions) 
  {
    os << "Reaction [" << setw(3) << num << "] ";
    //os << "Reaction: ";
    SSALibUtil::printReaction(os, *reactions);
    os << endl;
    ++reactions;
    ++num;
  }

  // print initialConditions

  num = 0;
  InitialCondition** icl = problem->initialConditions;
  while (*icl) 
  {
    os << "InitialCondition [" << setw(3) << num << "] "; 
    SSALibUtil::printInitialCondition(os, *icl);
    os << endl;
    ++icl;
    ++num;
  }
}

/**
 * print Reaction
 */   
void
SSALibUtil::printReaction(ostream& os, const SSAReaction *reaction)
{
  // print propensity
  os << " propensity " << setw(6) << reaction->propensity;
  // print reactants

  int num = 0;
  Term** terms = reaction->reactants;
  os << " [reactant] ";
  while (*terms) 
  {
    //os << "	";
    //os << " reactant [" << setw(3) << num << "] ";
    SSALibUtil::printTerm(os, *terms);
    ++terms;
    ++num;
    if(*terms) cout << " + ";
  }

  // print products

  num = 0;
  terms = reaction->products;
  os << " [product] ";
  while (*terms) 
  {
    //os << "	";
    //os << " product  [" << setw(3) << num << "] ";
    SSALibUtil::printTerm(os, *terms);
    ++terms;
    ++num;
    if(*terms) cout << " + ";
  }

}

/**
 * print InitialCondition
 */   
void
SSALibUtil::printInitialCondition(ostream& os, const InitialCondition *ic)
{
  os << ic->participant->name << " = " << ic->population;
}

/**
 * print Term
 */   
void
SSALibUtil::printTerm(ostream& os, const Term *term)
{
  os << term->coefficient << "*" << term->participant->name;
}

/**
 * print Trajectory
 */   
void
SSALibUtil::printTrajectory(ostream& os, const SSATrajectory *)
{
}

