/**
 * SBML-SSAlib bridge: a bridge library to connect SSAlib and SBML
 *
 * Copyright (C) 2004-2009, SBML-SSA Team, Keio/Seikei University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *                    
 * @file    SSASolverLauncher.h
 * @brief   Launcher for SSA solvers
 * @author  Keio/Seikei SBML-SSA Team.
 */

#ifndef SSASolverLauncher_h
#define SSASolverLauncher_h

#include "common.h"
#include <sbml/SBMLTypes.h>

class SSASolverLauncher
{
public:
  /**
   * runSimulation
   */   
  static SSATrajectory* runSimulation(SSASolverType_t solverType, SSAProblem* problem, 
                                      SSATimeLine *timeLine);

  /**
   * getNumSolver
   */   
  static int getNumSolvers();

};

#endif  /* SSASolverLauncher_h */
