/**
 * SBML-SSAlib bridge: a bridge library to connect SSAlib and SBML
 *
 * Copyright (C) 2004-2009, SBML-SSA Team, Keio/Seikei University.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *                    
 * @file    SSASolverLauncher.cpp
 * @brief   Launcher for SSA solvers
 * @author  Keio/Seikei SBML-SSA Team.
 */

#include "SSASolverLauncher.h"

/**
 * runSimulation
 */   
SSATrajectory* 
SSASolverLauncher::runSimulation(SSASolverType_t solverType, SSAProblem* problem, 
                                 SSATimeLine *timeLine)
{
  if (!problem || !timeLine)
  {
    return 0;
  }     
   
  SSATrajectory *trajectory = 0;
  
  switch(solverType)
  {
  case LIBSSA_DirectLinear: // DirectLinear
    trajectory = DirectLinear(problem, timeLine);
    break;
  default:
    trajectory = DirectLinear(problem, timeLine);
  }
  
  return trajectory;
}

/**
 * getNumSolver
 */   
int 
SSASolverLauncher::getNumSolvers()
{
  return LIBSSA_SolverType_Num;   
}
