/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] ddataout, ddatain ;
   wire [`DATA_W-1:0] iaddr;
   wire [`DATA_W-1:0] daddr;
   wire we0, we1;
   reg [`DATA_W/2-1:0] dmem0 [0:`DEPTH/2-1];
   reg [`DATA_W/2-1:0] dmem1 [0:`DEPTH/2-1];
   reg [`DATA_W-1:0] imem [0:`DEPTH-1];
   wire flag;

   always #(STEP/2) begin
            clk <= ~clk;
   end

   poco poco_1(.clk(clk), .rst_n(rst_n), .idatain(imem[iaddr]),
               .ddatain(ddatain), .iaddr(iaddr), .daddr(daddr),
               .ddataout(ddataout), .we1(we1), .we0(we0));
   disp disp_1(.clk(clk), .rst_n(rst_n), .data(ddataout[7:0]),
	.we(we1 & daddr[15]), .flag(flag) );

   always @(posedge clk) 
   begin 
      if(we0 & ~daddr[15]) dmem0[daddr[15:1]] <= ddataout[15:8];
   end
   always @(posedge clk) 
   begin 
      if(we1 & ~daddr[15]) dmem1[daddr[15:1]] <= ddataout[7:0];
   end

   assign ddatain = daddr[15] ? {15'b0,flag} : {dmem0[daddr[15:1]],dmem1[daddr[15:1]]};
   initial begin
      $dumpfile("poco.vcd");
      $dumpvars(0,test);
      $readmemh("dmem0.dat", dmem0);
      $readmemh("dmem1.dat", dmem1);
      $readmemb("imem.dat", imem);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   #(STEP*100)            
   $finish;
   end

/*
   always @(negedge clk) begin
      $display("stat:%b pc:%h ir:%b", poco_1.stat, poco_1.pc, poco_1.ir);
      $display("reg:%h %h %h %h %h %h %h %h", 
	poco_1.rfile_1.rf[0], poco_1.rfile_1.rf[1], poco_1.rfile_1.rf[2],
	poco_1.rfile_1.rf[3], poco_1.rfile_1.rf[4], poco_1.rfile_1.rf[5],
	poco_1.rfile_1.rf[6], poco_1.rfile_1.rf[7]); 
   end */
endmodule
