`include "def.h"
module datapath2(
input clk, input rst_n,
input [`OPCODE_W-1:0] opcode,
input [`DATA_W-1:0] ddatain,
output we,
output [`ADDR_W-1:0] pcout,
output [`DATA_W-1:0] accout);

reg [`DATA_W-1:0] accum;
reg [`ADDR_W-1:0] pc;
wire [`DATA_W-1:0] alu_y;

assign we = (opcode == `OP_ST);
assign accout = accum;
assign pcout  = pc;
alu alu_1(.a(accum), .b(ddatain), .s(opcode[`SEL_W-1:0]), .y(alu_y));

always @(posedge clk or negedge rst_n)
begin
   if(!rst_n) pc <= 0;
   else pc <= pc + 1;
end

always @(posedge clk or negedge rst_n)
begin
    if(!rst_n) accum <= 0;
    else if(opcode !=`OP_ST) accum <= alu_y;
end

endmodule

