/* test bench */
`timescale 1ns/1ps
module test;
parameter STEP = 10;
   reg clk, rst_n;
   reg right, left; 
   wire [7:0] led ; 
   always #(STEP/2) begin
            clk <= ~clk;
   end

   pp pp_1(.clk(clk), .rst_n(rst_n), .right(right),
               .left(left), .led(led));
			   
   initial begin
      $dumpfile("pp.vcd");
      $dumpvars(0,test);
      clk <= 1'b0;
      rst_n <= 1'b0;
	  right <= 1'b0;
	  left <= 1'b0;
   #(STEP*1/4)
   #STEP
      rst_n <= 1'b1;
   #(STEP*7)            
   	  left <=1'b1;
   #STEP
   	  left <=1'b0;
   #(STEP*7)            
   	  right <=1'b1;
   #STEP
   	  right <=1'b0;
   #(STEP*9)            
   $finish;
   end

   always @(negedge clk) begin
      $display("%b %b %b", left, led, right);
   end
endmodule
