module mmem (
	input [9:0] addr,
	input [15:0] datain,
	output [15:0] dataout,
	output rdy,
	input req,
	input we, block,
	input clk);

reg [15:0] mem[0:1023];
reg [3:0] count;

always @(posedge clk) begin
	if(!req) count <= 0;
	else if( (block & count != 4'b1111) |
		(~block & we & count != 4'b1000)) count <= count + 1;
end

assign rdy = count[3];
assign dataout = rdy ? mem[{addr[9:3],count[2:0]}]:16'b0; 

always @(posedge clk) begin
	if(block & rdy & we) mem[{addr[9:3],count[2:0]}] <= datain;
	else if(~block & rdy & we) mem[addr] <= datain;
end

endmodule
