set search_path [concat "/home/cad/lib/osu_stdcells/lib/tsmc018/lib/" $search_path]
set LIB_MAX_FILE {osu018_stdcells.db  }

set link_library $LIB_MAX_FILE
set target_library $LIB_MAX_FILE

read_verilog alu.v
read_verilog rfile.v
read_verilog poco1.v
current_design "poco"
create_clock -period 8.0 clk 
set_input_delay 2.5 -clock clk [find port "idatain*"]
set_input_delay 7.0 -clock clk [find port "ddatain*"]

set_output_delay 7.5 -clock clk [find port "iaddr*"]
set_output_delay 3.0 -clock clk [find port "daddr*"]
set_output_delay 3.0 -clock clk [find port "ddataout*"]
set_output_delay 3.0 -clock clk [find port "we"]

set_max_fanout 12 [current_design]

set_max_area 0

compile -map_effort high -area_effort medium

report_timing -max_paths 10

report_area

report_power

write -hier -format verilog -output poco.vnet

quit
