`include "def.h"
module poco(
input clk, rst_n,
input [`DATA_W-1:0] idatain,
input [`DATA_W-1:0] ddatain,
output [`DATA_W-1:0] iaddr, daddr,
output [`DATA_W-1:0] ddataout,
output we);

reg [`DATA_W-1:0] pc;
wire [`DATA_W-1:0] pcadd, pcnext;
wire [`DATA_W-1:0] rf_a, rf_b, rf_c;
wire [`DATA_W-1:0] alu_b, alu_y;
wire [`OPCODE_W-1:0] opcode;
wire [`OPCODE_W-1:0] func;
wire [`REG_W-1:0] rs, rd, cadr;
wire [`SEL_W-1:0] com;
wire [`IMM_W-1:0] imm;
wire rwe;
wire zero, mi, pcjr, casel;
wire [1:0] comsel, pcsel, rf_csel, alu_bsel;

assign ddataout = rf_a;
assign iaddr = pc;
assign daddr = rf_b;

assign {opcode, rd, rs, func} = idatain;
assign imm = idatain[`IMM_W-1:0];

decode decode_1 (.opcode(opcode), .func(func), .zero(zero), .mi(mi),
	.alu_bsel(alu_bsel), .comsel(comsel), .rf_csel(rf_csel),
	.pcsel(pcsel), .we(we), .rwe(rwe), .casel(casel), .pcjr(pcjr));

assign alu_b = alu_bsel==2'b01 ? {{8{imm[7]}},imm} :
		alu_bsel == 2'b10 ? {8'b0,imm} :
		alu_bsel == 2'b11 ? {imm, 8'b0} : rf_b;

assign com = comsel==2'b01 ? `ALU_ADD: 
		comsel==2'b10 ? `ALU_THB: func[`SEL_W-1:0];

assign rf_c = rf_csel==2'b01  ? ddatain : rf_csel==2'b10 ? pc+1 : alu_y;

assign cadr = casel ? 3'b111 : rd;

alu alu_1(.a(rf_a), .b(alu_b), .s(com), .y(alu_y));

rfile rfile_1(.clk(clk), .a(rf_a), .aadr(rd), .b(rf_b), .badr(rs), 
	.c(rf_c), .cadr(cadr), .we(rwe));

assign zero = rf_a == 16'b0;
assign mi = rf_a[15];
assign pcadd = pcsel == 2'b01 ? {{8{imm[7]}},imm} :
		pcsel == 2'b10 ? {{5{idatain[10]}},idatain[10:0]}: 0;

assign pcnext = pcjr ? rf_a: pc+pcadd+1;

always @(posedge clk or negedge rst_n) 
begin 
   if(!rst_n) pc <= 0;
   else 
     pc <= pcnext;
end

endmodule
