`include "def.h"
module poco(
input clk, rst_n,
input [`DATA_W-1:0] idatain,
input [`DATA_W-1:0] ddatain,
output [`DATA_W-1:0] iaddr, daddr,
output [`DATA_W-1:0] ddataout,
output we);

reg [`DATA_W-1:0] pc;
wire [`DATA_W-1:0] pcadd, pcnext;
wire [`DATA_W-1:0] rf_a, rf_b, rf_c;
wire [`DATA_W-1:0] alu_b, alu_y;
wire [`OPCODE_W-1:0] opcode;
wire [`OPCODE_W-1:0] func;
wire [`REG_W-1:0] rs, rd, cadr;
wire [`SEL_W-1:0] com;
wire [`IMM_W-1:0] imm;
wire rwe;
wire casel;
wire [1:0] comsel, pcsel, rf_csel, alu_bsel;
wire bez_op, bnz_op, bpl_op, bmi_op, jmp_op, jal_op, jr_op;
assign bez_op = (opcode == `OP_BEZ);
assign bnz_op = (opcode == `OP_BNZ);
assign bpl_op = (opcode == `OP_BPL);
assign bmi_op = (opcode == `OP_BMI);
assign jmp_op = (opcode == `OP_JMP);
assign jal_op = (opcode == `OP_JAL);
assign jr_op = (opcode == `OP_REG) & (func == `F_JR);


assign ddataout = rf_a;
assign iaddr = pc;
assign daddr = rf_b;

assign {opcode, rd, rs, func} = idatain;
assign imm = idatain[`IMM_W-1:0];

assign {alu_bsel, comsel, rf_csel, rwe, casel} = decode(opcode,func);

assign alu_b = alu_bsel==2'b01 ? {{8{imm[7]}},imm} :
		alu_bsel == 2'b10 ? {8'b0,imm} :
		alu_bsel == 2'b11 ? {imm, 8'b0} : rf_b;

assign com = comsel==2'b01 ? `ALU_ADD: 
		comsel==2'b10 ? `ALU_THB: func[`SEL_W-1:0];

assign rf_c = rf_csel==2'b01  ? ddatain : rf_csel==2'b10 ? pc+1 : alu_y;

assign cadr = casel ? 3'b111 : rd;

alu alu_1(.a(rf_a), .b(alu_b), .s(com), .y(alu_y));

rfile rfile_1(.clk(clk), .a(rf_a), .aadr(rd), .b(rf_b), .badr(rs), 
	.c(rf_c), .cadr(cadr), .we(rwe));

always @(posedge clk or negedge rst_n)
begin
   if(!rst_n) pc <= 0;
   else if ((bez_op & rf_a == 16'b0 ) | (bnz_op & rf_a != 16'b0) |
                (bpl_op & ~rf_a[15]) | (bmi_op & rf_a[15]))
     pc <= pc +{{8{imm[7]}},imm}+1 ;
   else if (jmp_op | jal_op)
    pc <= pc + {{5{idatain[10]}},idatain[10:0]}+1;
   else if(jr_op)
    pc <= rf_a;
   else
     pc <= pc+1;
end

function [7:0] decode(
	input [`OPCODE_W-1:0] op,
	input [`OPCODE_W-1:0] fu);
  reg [1:0] alu_bsel, comsel, rf_csel;
  reg rwe, casel;
  begin
  alu_bsel = 2'b00;
  comsel = 2'b00;
  rf_csel = 2'b00;
  rwe = 1'b0;
  casel = 1'b0;
  case (op)
	`OP_REG:
		if(fu==`F_LD) begin
			rwe = 1'b1;
			rf_csel = 2'b01; end
		else if(fu[4:3] == 2'b00) 
			rwe = 1'b1;
	`OP_LDI: begin
		rwe = 1'b1;
		comsel = 2'b10;
		alu_bsel = 2'b01; end
	`OP_LDIU: begin
		rwe = 1'b1;
		comsel = 2'b10;
		alu_bsel = 2'b10; end
	`OP_ADDI: begin
		rwe = 1'b1;
		comsel = 2'b01;
		alu_bsel = 2'b01; end
	`OP_ADDIU: begin
		rwe = 1'b1;
		comsel = 2'b01;
		alu_bsel = 2'b10; end
	`OP_LDHI: begin
		rwe = 1'b1;
		comsel = 2'b10;
		alu_bsel = 2'b11; end
	`OP_JAL: begin
		rwe = 1'b1;
		casel = 1'b1; 
		rf_csel = 2'b10; end
  endcase
  decode = {alu_bsel, comsel, rf_csel, rwe, casel};
  end
  endfunction

endmodule
