/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] dataout ;
   wire [`DATA_W-1:0] addr;
   wire we;
   reg [`DATA_W-1:0] mem [0:`DEPTH-1];

   always #(STEP/2) begin
            clk <= ~clk;
   end

   poco poco_1(.clk(clk), .rst_n(rst_n), .datain(mem[addr]),
               .addr(addr), .dataout(dataout), .we(we));

   always @(posedge clk) 
   begin 
      if(we) mem[addr] <= dataout;
   end

   initial begin
      $dumpfile("poco.vcd");
      $dumpvars(0,test);
      $readmemb("mem.dat", mem);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   #(STEP*150)            
   $finish;
   end

   always @(negedge clk) begin
      $display("stat:%b pc:%h ir:%b", poco_1.stat, poco_1.pc, poco_1.ir);
      $display("reg:%h %h %h %h %h %h %h %h", 
	poco_1.rfile_1.r0, poco_1.rfile_1.r1, poco_1.rfile_1.r2,
	poco_1.rfile_1.r3, poco_1.rfile_1.r4, poco_1.rfile_1.r5,
	poco_1.rfile_1.r6, poco_1.rfile_1.r7);
      $display("mem:%h %h %h %h", mem[10], mem[11], mem[12], mem[13]);
   end
endmodule
