setenv LANG C

if ($?LD_ASSUME_KERNEL) then
   echo "The LD_ASSUME_KERNEL environment variable is set. Xilinx software will not work correctly and may crash if this variable is set. Please unset the variable before running any Xilinx software."
else
   setenv PLATFORM lin64
   setenv XILINX /home/cad/xilinx/ISE-10.1/ISE

   if ($?PATH) then
      setenv PATH ${XILINX}/bin/${PLATFORM}:${PATH}
   else
      setenv PATH ${XILINX}/bin/${PLATFORM}
   endif

   if ($?LMC_HOME) then
      setenv LMC_HOME ${XILINX}/smartmodel/${PLATFORM}/installed_${PLATFORM}:${LMC_HOME}
   else
      setenv LMC_HOME ${XILINX}/smartmodel/${PLATFORM}/installed_${PLATFORM}
   endif

   if ($?LD_LIBRARY_PATH) then
      setenv LD_LIBRARY_PATH ${XILINX}/lib/${PLATFORM}:/usr/X11R6/lib:${LMC_HOME}/lib/linux.lib:${LMC_HOME}/lib/amd64.lib:${LD_LIBRARY_PATH}
   else
      setenv LD_LIBRARY_PATH ${XILINX}/lib/${PLATFORM}:/usr/X11R6/lib:${LMC_HOME}/lib/linux.lib:${LMC_HOME}/lib/amd64.lib
   endif

   set qtDir="${HOME}/.qt"

   set myxilinxrc="${qtDir}/xilinxrc"

   if ($?SYSCONF) then
      if ( ( -e "${SYSCONF}/xilinxrc" ) && ( ! -e ${myxilinxrc} ) ) then
         mkdir -p "${qtDir}"
         cp "${SYSCONF}/xilinxrc" ${myxilinxrc}
      endif
   else if ( ( -e "/Xilinx/xilinxrc" ) && ( ! -e ${myxilinxrc} ) ) then
      mkdir -p "${qtDir}"
      cp "/Xilinx/xilinxrc" ${myxilinxrc}
   endif
endif
