`define LEDWIDTH 7:0

`define LED_ZERO 4'd0
`define LED_ONE  4'd1

`define ENABLE_ 1'b0
`define ENABLE  1'b1
`define HIGH    1'b1
`define LOW     1'b0

//LCD signal
`define LCDDATA 3:0
`define LCDDATA_RSRW     5:0
`define LCDINITIALCOUNTER 19:0
`define LCDINITIALSTATE  2:0
`define LCDPULSE  3:0
`define LCDCOMMAND 9:0
`define LCDSTATE   2:0
`define LCDBUFFERCOUNTER 1:0
`define LCDTRANSFERSTATUS 2:0
`define LCDTRANSFERCOUNTER 16:0

`define LCD_INIT_COUNTER_ZERO 20'd0
`define LCD_INIT_COUNTER_ONE  20'd1
//`define LCD_INIT_COUNTER_FIRST   20'd749_999
//`define LCD_INIT_COUNTER_SECOND  20'd204_999
//`define LCD_INIT_COUNTER_THIRD   20'd4_999
//`define LCD_INIT_COUNTER_FOURTH  20'd1_999
//`define LCD_INIT_COUNTER_FIFTH   20'd1_999
`define LCD_INIT_COUNTER_FIRST   20'd374_999
`define LCD_INIT_COUNTER_SECOND  20'd102_499
`define LCD_INIT_COUNTER_THIRD   20'd2_499
`define LCD_INIT_COUNTER_FOURTH  20'd999
`define LCD_INIT_COUNTER_FIFTH   20'd999
`define LCD_INIT_STATUS_ZERO  3'd0
`define LCD_INIT_STATUS_ONE   3'd1
`define LCD_INIT_STATUS_TWO   3'd2
`define LCD_INIT_STATUS_THREE 3'd3
`define LCD_INIT_STATUS_FOUR  3'd4

`define LCD_DATA_ZERO   4'd0
`define LCD_DATA_ONE    4'd1
`define LCD_DATA_TWO    4'd2
`define LCD_DATA_THREE  4'd3
`define LCD_DATA_RSRW_ZERO 6'd0

`define LCD_PULSE_ZERO  4'd0
`define LCD_PULSE_ONE   4'd1
`define LCD_PULSE_START 4'd1
`define LCD_PULSE_END   4'd12
`define LCD_PULSE_MAX   4'd14
//`define LCD_PULSE_END   4'd6
//`define LCD_PULSE_MAX   4'd7

`define LCD_COMMAND_ZERO 10'd0
`define LCD_COMMAND_FUNCTION_SET       10'b00_0010_1000
`define LCD_COMMAND_RETURN_CURSOR_HOME 10'b00_0000_0010
`define LCD_COMMAND_CLEAR_DISPLAY      10'b00_0000_0001

`define LCD_ST_ZERO     3'd0
`define LCD_ST_ONE      3'd1
`define LCD_ST_TWO      3'd2
`define LCD_ST_THREE    3'd3
`define LCD_ST_FOUR     3'd4
`define LCD_ST_FIVE     3'd5
`define LCD_ST_SIX      3'd6

`define LCD_BUFFER_COUNTER_ZERO 2'd0
`define LCD_BUFFER_COUNTER_ONE  2'd1
`define LCD_BUFFER_COUNTER_MAX  2'd3

`define LCD_TRANSFER_STATUS_ZERO   3'd0
`define LCD_TRANSFER_STATUS_ONE    3'd1
`define LCD_TRANSFER_STATUS_TWO    3'd2
`define LCD_TRANSFER_STATUS_THREE  3'd3
`define LCD_TRANSFER_STATUS_FOUR   3'd4
`define LCD_TRANSFER_STATUS_FIVE   3'd5

`define LCD_TRANSFER_COUNTER_ZERO   17'd0
`define LCD_TRANSFER_COUNTER_ONE    17'd1
//`define LCD_TRANSFER_COUNTER_1US    17'd65    // 50 + 16
//`define LCD_TRANSFER_COUNTER_1_64MS 17'd82_015 // 82,000 + 16
//`define LCD_TRANSFER_COUNTER_40US   17'd2_015 // 2,000 + 16
`define LCD_TRANSFER_COUNTER_1US    17'd32    // 50 + 16
`define LCD_TRANSFER_COUNTER_1_64MS 17'd41_007 // 82,000 + 16
`define LCD_TRANSFER_COUNTER_40US   17'd1_007 // 2,000 + 16

// RS232C
`define RS232CDATA 7:0
`define RSRXSTATUS 3:0
`define RSTXSTATUS 3:0
`define RSRXCOUNT  6:0
`define RSTXCOUNT  8:0
`define RSRXCOUNTSTATUS 1:0

`define RS232CDATA_ZERO 8'd0
`define RSRXSTATUS_ZERO 4'd0
`define RSRXSTATUS_ONE 4'd1
`define RSRXSTATUS_TEN 4'd10
`define RSTXSTATUS_ZERO 4'd0
`define RSTXSTATUS_ONE 4'd1
`define RSTXSTATUS_ELEVEN 4'd11

`define RSRXCOUNT_ZERO 7'd0
`define RSRXCOUNT_ONE  7'd1
`define RSRXCOUNT_MAX  7'd108
`define RSTXCOUNT_ZERO 9'd0
`define RSTXCOUNT_ONE  9'd1
`define RSTXCOUNT_MAX  9'd434
`define RSRXCOUNTSTATUS_ZERO 2'd0
`define RSRXCOUNTSTATUS_ONE  2'd1
