`include "mydefinition.h"

module lcdUser( clk, rst, userData, userDataEnable,
		command, commandEnable);

   input clk, rst;
   input [`LCDCOMMAND] userData;
   input 	       userDataEnable;
   
   output [`LCDCOMMAND] command;
   output 		commandEnable;

   reg [`LCDCOMMAND] 	command;
   reg 			commandEnable;

   reg [`LCDSTATE] 	lcdState;

   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 lcdState <= `LCD_ST_ZERO;
      end else begin
	 if ( lcdState == `LCD_ST_FIVE) begin
	    lcdState <= lcdState;
	 end else begin
	    lcdState <= lcdState + `LCD_ST_ONE;
	 end
      end
   end
   
   always @ ( posedge clk or posedge rst) begin
      if ( rst == `ENABLE) begin
	 command <= `LCD_COMMAND_ZERO;
	 commandEnable <= `LOW;
      end else begin
	 case ( lcdState)
	   `LCD_ST_ZERO:begin
	      command <= `LCD_COMMAND_FUNCTION_SET;
	      commandEnable <= `HIGH;
	   end
	   
	   `LCD_ST_ONE:begin
	      command <= 10'b00_0000_0110;
	      commandEnable <= `HIGH;
	   end
	   
	   `LCD_ST_TWO:begin
	      command <= 10'b00_0000_1100;
	      commandEnable <= `HIGH;
	   end
	   
	   `LCD_ST_THREE:begin
	      command <= `LCD_COMMAND_CLEAR_DISPLAY;
	      commandEnable <= `HIGH;
	   end

	   `LCD_ST_FOUR:begin
		   command <= 10'b00_1000_0000; //set DD RAM address 0x0
		   commandEnable <= `HIGH;
	   end
	
	   `LCD_ST_FIVE:begin
	      if ( userDataEnable) begin
		 command <= userData;
		 commandEnable <= `HIGH;
	      end else begin
		 command <= `LCD_COMMAND_ZERO;
		 commandEnable <= `LOW;
	      end
	   end
	   
	   default:begin
	      command <= `LCD_COMMAND_ZERO;
	      commandEnable <= `LOW;
	   end
/*
	   `LCD_ST_FOUR:
	     command <= 10'b00_1000_0010; // set DD RAM addres 0x02

	   `LCD_ST_FIVE:
	     command <= 10'b10_1100_1010; // write "ha"

	   `LCD_ST_SIX:
	     command <= 10'b10_1101_1011; // write "ro"

	   `LCD_ST_SEVEN:
	     command <= 10'b10_1010_1011; // write "xo"
	   
	   `LCD_ST_EIGHT:
	     command <= 10'b10_1111_1110; // write " "

	   `LCD_ST_NINE:
	     command <= 10'b10_1101_1100; // write "wa"

	   `LCD_ST_TEN:
	     command <= 10'b10_0010_1101; // write "-"

	   `LCD_ST_ELEVEN:
	     command <= 10'b10_1101_1001; // write "ru"

	   `LCD_ST_TWELVE:
	     command <= 10'b10_1100_0100; // write "to"

	   `LCD_ST_THIRTEEN:
	     command <= 10'b10_1101_1110; // write " '' "

	   `LCD_ST_FOURTEEN:
	     command <= 10'b10_0010_0001; // write "!"
 */
	 endcase
	 
      end
   end
   
endmodule // lcdUser
