#!/usr/local64/perl/bin/perl -w

##$B3X@8<B83$N3'MM$X(B
#$B!y#1!'$^$:$3$l$rJT=8(B
$top_module_name = "poco_top"; 
#$B$3$3$K%H%C%W%b%8%e!<%kL>$r5-=R(B
#$B%H%C%W%b%8%e!<%k(B:$B0lHV:G>e0L$K$/$k%U%!%$%k(B(.v$B$O$$$i$J$$(B)

#$B!y(B2$B!'%b%8%e!<%k72$r5-=R(B
#$B%H%C%W%b%8%e!<%k$H$=$NB>$N%U%!%$%kL>$r5-=R(B
#$B:#EY$O(B".v"$B$,I,MW(B
@modules=(
	  "alu.v",         #$BJ8Kv$K(B "," $B$rK:$l$F$O$$$1$J$$(B
	  "chattering.v",
	  "dmem.v",
	  "imem.v",
	  "lcdBuffer.v",
	  "lcdDecoder.v",
	  "lcdFifo.v",
	  "lcdInitializer.v",
	  "lcdPulseCounter.v",
	  "lcdTop.v",
	  "lcdUser.v",
	  "lcd.v",
	  "poco1.v",
	  "pocoDCM.v",
	  "poco_top.v",
	  "rfile.v"        #$B:G8e$N%U%!%$%k$K8B$j(B ","$B$O$$$i$J$$(B
	  );

#$B!y(B3$B!'<!$O(BMakefile$B$rJT=8$9$k$h!#(B
#$B0UM_E*$J7/$O0J2<$N%*%W%7%g%s$KJQ99$r2C$($?$j!"4V0c$$$r;XE&!"<ALd$7$F$[$7$$!#(B
#morisita@am.ics.keio.ac.jp @ 2010$BG/B46HM=Dj(B

$top_file_name = "$top_module_name";
$device_name = "xc3s700an-4-fgg484";
$ise_path = "/usr/local/Xilinx/11.1/ISE";
$xst_path = "$ise_path/bin/lin/xst";

if(@ARGV == 1){

    @delte_extension = qw(.lso .ngc .ngr .prj .syr .xst _vhdl.prj .ngd);

    if($ARGV[0] eq 'clean'){
        foreach(@delte_extension){
            $tmp = $top_module_name."$_";
            if(-e $tmp){
                print "delete file $tmp \n";
                unlink($tmp);
            }
        }
        $tmp = "xst";
        system("rm -rf $tmp");
        print "delete directory $tmp \n";
    }
    exit(1);
}



print $ise_path."\n";
print $xst_path."\n";

system("mkdir -p xst/projnav.tmp");
#dump.xst, projnav.tmp work

$prj="";
for($i=0;$i<@modules;$i++){
    $prj.="verilog work \"".$modules[$i]."\"\n";
}
print $prj;

$lso="work"."\n";
$xst = &xst($top_file_name, $top_module_name, $device_name);

$prjfile = "$top_file_name.prj";
$xstfile = "$top_file_name.xst";
$lsofile = "$top_file_name.lso";

open(FP,">$prjfile");
print FP $prj;
close(FP);

open(FP,">$xstfile");
print FP $xst;
close(FP);

open(FP,">$lsofile");
print FP $lso;
close(FP);


system("env LD_LIBRARY_PATH=$ise_path/bin/lin $xst_path -ifn $top_file_name.xst -ofn $top_file_name.syr");


$flag = 0;
open(FP2,"<$top_file_name.syr");
while($line=<FP2>){
    if($line =~ /Device utilization summary:/){
        print "=========================================================================\n";
        $flag = 1;
    }
    elsif($line =~ /Timing Summary:/){
        $flag = 1;
    }
    elsif($line =~ /Timing Detail:/
          || $line =~ /TIMING REPORT/){
        $flag = 0;
    }

    print $line if($flag == 1);
}
print "=========================================================================\n";
close(FP2);


sub xst{
my $xst="";
my $top_file_name = $_[0];
my $top_module_name = $_[1];
my $device_name = $_[2];

$xst.= <<EOF;
set -tmpdir "./xst/projnav.tmp"
set -xsthdpdir "./xst"
run
-ifn $top_file_name.prj
-ifmt mixed
-ofn $top_file_name
-ofmt NGC
-p $device_name
-top $top_module_name
-opt_mode Speed
-opt_level 2
-lso $top_file_name.lso
-verilog2001 YES
-vlgcase full
-case maintain
-fsm_extract yes
-fsm_style lut
-fsm_encoding auto
-ram_extract yes
-ram_style auto
-rom_extract yes
-rom_style auto
-mult_style auto
-mux_style auto
-decoder_extract yes
-priority_extract yes
-safe_implementation yes
-shreg_extract yes
-shift_extract yes
-xor_collapse yes
-resource_sharing yes
#-use_dsp48 auto
-auto_bram_packing yes
-bram_utilization_ratio 100
#-dsp_utilization_ratio 100
-max_fanout 500
-move_first_stage yes
-move_last_stage yes
-bufg 24
#-reduce_control_sets auto
-keep_hierarchy NO
-register_balancing yes
-iobuf YES
-slice_packing yes
-use_carry_chain yes
-use_clock_enable auto
-use_sync_set auto
-use_sync_reset auto
-cross_clock_analysis yes
-write_timing_constraints yes
-glob_opt allclocknets
-equivalent_register_removal yes
-netlist_hierarchy as_optimized
EOF

return $xst;
}
