//////////////////////////////////////////////////////
// Program: Sample game for pico expr
// Author : Q-Sassa
// memo   :
//         LED    ADDR    0x8000 0000_0000_xxxx_xxxx
//         DISP   ADDR    0xa000 0000_00cc_xxxx_xxxx
//         SWITCH ADDR    0xc000 0000_0000_xxxx_xxxx
//
//         r0          addr reg
//         r1, r2, r3  general purpose reg
//         r4          game counter
//         r5, r6      time counter
//         r7          pc (JAL)
//
//         random data in mem 0x00 ~ 0x18
//         score data in mem 0xa0
//         
//////////////////////////////////////////////////////

	
	//*** Initial Display Control ***//

	LDHI r0, #0xa0 //disp addr

	LDIU r1, #0x50 //P
	ST r1, (r0)
	LDIU r1, #0x55 //U
	ST r1, (r0)
	LDIU r1, #0x53 //S
	ST r1, (r0)
	LDIU r1, #0x48 //H
	ST r1, (r0)
	LDIU r1, #0x20 //(Space)
	ST r1, (r0)
	LDIU r1, #0x41 //A
	ST r1, (r0)
	LDIU r1, #0x4e //N
	ST r1, (r0)
	LDIU r1, #0x59 //Y
	ST r1, (r0)
	LDIU r1, #0x20 //(Space)
	ST r1, (r0)
	LDIU r1, #0x4b //K
	ST r1, (r0)
	LDIU r1, #0x45 //E
	ST r1, (r0)
	LDIU r1, #0x59 //Y
	ST r1, (r0)


	//*** Polling and Count up ***//

	LDHI r0, #0xc0 //switch addr
	LDIU r5, #0    //counter initializing
	LDIU r6, #0    //for rseed
	LDIU r7, #0
	LDIU r2, #0xF0 //mask bit

pl_1:	ADDI r5, #1	//count up
	ADDI r6, #3    
	ADDI r7, #5
	LD r1, (r0)    //load switch condition
	AND r1, r2     //masking
	BEZ r1, pl_1   //blanch even if switch is pushed


	//*** Game Start Display Control ***//

	LDHI r0, #0xa0 //disp addr
	LDIU r1, #0x01 //(clear char)
	ST r1, (r0)    //disp clear
	LDIU r1, #0x00 //init
	LDHI r1, #0x02 //(move cmd)
	ST r1, (r0)    //move cursor

	LDIU r1, #0x47 //G
	ST r1, (r0)
	LDIU r1, #0x41 //A
	ST r1, (r0)
	LDIU r1, #0x4d //M
	ST r1, (r0)
	LDIU r1, #0x45 //E
	ST r1, (r0)
	LDIU r1, #0x20 //(space)
	ST r1, (r0)
	LDIU r1, #0x53 //S
	ST r1, (r0)
	LDIU r1, #0x54 //T
	ST r1, (r0)
	LDIU r1, #0x41 //A
	ST r1, (r0)
	LDIU r1, #0x52 //R
	ST r1, (r0)
	LDIU r1, #0x54 //T
	ST r1, (r0)


	//*** make random number ***//

	LDIU r0, #0x00 //mem addr init
	LDIU r4, #0x08 //loop count
make_r:	LDIU r1, #0x0c //load mask
	LDIU r2, #0x0c
	LDIU r3, #0x0c

	AND r1, r5     //masking
	AND r2, r6
	AND r3, r7

	ST r1, (r0)    //store data to memory
	ADDI r0, #1    //addr increment
	ST r2, (r0)    
	ADDI r0, #1    
	ST r3, (r0)    
	ADDI r0, #1    

	SR r5          //shift right for making data
	SR r5
	SR r6
	SR r6
	SR r7
	SR r7

	ADDI r4, #-1   //loop count decrement
	BNZ r4, make_r //branch if loop counter equal zero


	//*** LED decoder ***//

	LDIU r4, #0x18 //game counter init
l_dec:	LD r1, (r4)    //LD random data

	BNZ r1, pat1   //branch if data equal 0
	LDIU r3, #0x07 //load led pattern  o o o
	JMP d_end      //jump to decoder end
pat1:	LDIU r2, #1    //load comp data
	SUB r2, r1     //compare
	BNZ r2, pat2   //branch if data equal 1
	LDIU r3, #0x01 //load led pattern  x x o
	JMP d_end      //jump to decoder end
pat2:	LDIU r2, #2    //load comp data
	SUB r2, r1     //compare
	BNZ r2, pat3   //branch if data equal 2
	LDIU r3, #0x02 //load led pattern  x o x
	JMP d_end      //jump to decoder end
pat3:	LDIU r3, #0x04 //load led pattern  o x x
d_end:	NOP


	//*** LED control ***//

	LDHI r0, #0x80 //LED addr
	ST r3, (r0)    //store pattern for LED

	LDHI r0, #0xc0 //Switch addr
	LDHI r5, #0x01 //timer 1
t1_l:	LDHI r6, #0x5f //timer 2

t2_l: 	LD r1, (r0)    //load switch condition
	AND r1, r3     //compare led and switch
	BNZ r1, hit    //branch if correct switch is pushed
	ADDI r6, #-1   //decrement timer 2
	BNZ r6, t2_l   //branch if timer 2 not equal 0

	ADDI r5, #-1   //decrement timer 1
	BNZ r5, t1_l   //branch if timer 1 not equal 0
	JMP n_hit      //jump to no hit pattern

hit:	LDIU r0, #0xa0 //score addr
	LD r1, (r0)    //load current score
	ADDI r1, #1    //add score
	ST r1, (r0)    //store new score

n_hit:	LDHI r0, #0x80 //LED addr
	LDIU r1, #0x00 //r1 init
	ST r1, (r0)    //clear LED


	//*** 1.5sec timer for game interval ***//

	LDHI r5, #0x01 //timer 1
intv1:	LDHI r6, #0xef //timer 2

intv2:	ADDI r6, #-1   //decrement timer 2
	BNZ r6, intv2  //branch if timer 2 not equal 0
	ADDI r5, #-1   //decrement timer 1
	BNZ r5, intv1  //branch if timer 1 not equal 0


	//*** game counter ***//

	ADDI r4, #-1   //decrement game counter
	BNZ r4, l_dec  //branch if game counter not equal 0


	//*** score decoder ***//

	LDIU r0, #0xa0 //score addr
	LD r2, (r0)    //load score (and one place)
	LDIU r1, #0x0a  //divider
	LDIU r3, #0x00  //ans (= ten place)
	ADDI r3, #-1   //ans fix

div:	LDHI r7, #0x80  //mask bit
	ADDI r3, #1    //increment answer
	SUB r2, r1     //r2 - r1 for div
	AND r7, r2     //masking
	BEZ r7, div    //branch if r2 is negative
	ADD r2, r1     //div fix


	//*** data to ascii ***//

	ADDI r2, #0x30 //convert to ascii
	ADDI r3, #0x30 //convert to ascii


	//*** result display control ***//

	LDHI r0, #0xa0 //disp addr
	LDIU r1, #0x01 //(clear char)
	ST r1, (r0)    //disp clear
	LDIU r1, #0x00 //init
	LDHI r1, #0x02 //(move cmd)
	ST r1, (r0)    //move cursor

	LDIU r1, #0x52 //R
	ST r1, (r0)
	LDIU r1, #0x45 //E
	ST r1, (r0)
	LDIU r1, #0x53 //S
	ST r1, (r0)
	LDIU r1, #0x55 //U
	ST r1, (r0)
	LDIU r1, #0x4c //L
	ST r1, (r0)
	LDIU r1, #0x54 //T
	ST r1, (r0)
	LDIU r1, #0x3a //:
	ST r1, (r0)
	ST r3, (r0)    //store ten place
	ST r2, (r0)    //store one place