/* test bench */
`timescale 1ns/1ps
`include "def.h"
module test_rv32i;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] ddataout, ddatain, dmemrd ;
   wire [`DATA_W-1:0] iaddr;
   wire [`DATA_W-1:0] daddr;
   wire [`DATA_W-1:0] idata, idata_imem, idata_intmem;
   wire [3:0] we;
   wire ecall_op;
   wire [7:0] odata;
   wire dispf, disp_en, inp_en, dmem_en, inpf, intmem_en;
   reg set;
   reg [`DATA_W/4-1:0] indata;
   assign disp_en = (daddr[31:4] == 28'hc000000);
   assign inp_en = (daddr[31:4] == 28'hc100000);
   assign intmem_en = (iaddr[31:16] == `DATA_W'h8000);
   assign dmem_en = (daddr[`DATA_W-1:18]==0);

   always #(STEP/2) begin
            clk <= ~clk;
   end

   rv32i rv32i_1(.clk(clk), .rst_n(rst_n), .instr(idata),
               .readdata(ddatain), .pc(iaddr), .aluresult(daddr),
               .writedata(ddataout), .we(we), .intrq(inpf), .ecall_op(ecall_op) );
   disp disp_1(.clk(clk), .rst_n(rst_n), .data(ddataout[23:16]),
       .we(we[2] & disp_en), .flag(dispf) );
   inmodule inmodule_1(.clk(clk), .rst_n(rst_n), .idata(indata), .odata(odata),
      .we(set), .re(inp_en & daddr[3:0] == 4'b0010), .flag(inpf));

  imem  imem_1(.a(iaddr[17:2]), .rd(idata_imem) );
  intmem  intmem_1(.a(iaddr[17:2]), .rd(idata_intmem) );
  dmem  dmem_1(.clk(clk), .a(daddr[17:2]), .rd(dmemrd), 
  					.wd(ddataout), .we({4{dmem_en}}&we) );
  assign ddatain = disp_en ? {7'b0,dispf,24'b0} : inp_en ? {7'b0,inpf,odata,16'b0} :
                                          dmemrd;
	assign idata = intmem_en ? idata_intmem : idata_imem;


   initial begin
      $dumpfile("rv32i.vcd");
      $dumpvars(0);
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
	  set <= `DISABLE;
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   
  #(STEP*10)
  #(STEP*10)
      indata <= 8'h41;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*20)
      indata <= 8'h42;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*20)
      indata <= 8'h43;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*20)
      indata <= 8'h44;
      set <= `ENABLE;
   #STEP
      set <= `DISABLE;
   #(STEP*50)
   $finish;
   end
   always @(negedge clk) begin
      $display("pc:%h/%d idatain:%h", rv32i_1.pc, rv32i_1.pc, rv32i_1.instr);
      $display("x1:%h x2:%h x3:%h x4:%h x5:%h x6:%h x7:%h",
	    rv32i_1.rfile_1.rf[1], rv32i_1.rfile_1.rf[2],
	    rv32i_1.rfile_1.rf[3], rv32i_1.rfile_1.rf[4], rv32i_1.rfile_1.rf[5],
	    rv32i_1.rfile_1.rf[6], rv32i_1.rfile_1.rf[7] );
`ifdef REGALL
      $display("x8:%h x9:%h x10:%h x11:%h x12:%h x13:%h x14:%h x15:%h",
	      rv32i_1.rfile_1.rf[8], rv32i_1.rfile_1.rf[9],
		  rv32i_1.rfile_1.rf[10], rv32i_1.rfile_1.rf[11], rv32i_1.rfile_1.rf[12],
		  rv32i_1.rfile_1.rf[13], rv32i_1.rfile_1.rf[14], rv32i_1.rfile_1.rf[15] );
	 $display("x16:%h x17:%h x18:%h x19:%h x20:%h x21:%h x22:%h x23:%h",
	    rv32i_1.rfile_1.rf[16], rv32i_1.rfile_1.rf[17],
	    rv32i_1.rfile_1.rf[18], rv32i_1.rfile_1.rf[19], rv32i_1.rfile_1.rf[20],
	    rv32i_1.rfile_1.rf[21], rv32i_1.rfile_1.rf[22], rv32i_1.rfile_1.rf[23] );
     $display("x24:%h x25:%h x26:%h x27:%h x28:%h x29:%h x30:%h x31:%h",
        rv32i_1.rfile_1.rf[24], rv32i_1.rfile_1.rf[25],
        rv32i_1.rfile_1.rf[26], rv32i_1.rfile_1.rf[27], rv32i_1.rfile_1.rf[28],
        rv32i_1.rfile_1.rf[29], rv32i_1.rfile_1.rf[30], rv32i_1.rfile_1.rf[31] );
`endif
    $display("dmem:%h %h %h %h", dmem_1.mem[0], dmem_1.mem[1], dmem_1.mem[2], dmem_1.mem[3] );
	if(ecall_op) $finish;
   end 
endmodule
