/* test bench */
`timescale 1ns/1ps
`include "def.h"
`define CRDY_BIT 2'b10

module test;
parameter STEP = 10;
   reg clk, rst_n;
   wire [`DATA_W-1:0] odata, mdata, wdata ;
   wire [`DATA_W-1:0] daddr, iaddr, instr;
   wire we, req, mem_req, rdy, mem_rdy, ecall_op;
   reg [`DATA_W-1:0] imem [0:`DEPTH-1];
   reg [10:0] count,wcount,hit,miss;
   wire [9:0] maddr;

   always #(STEP/2) begin
            clk <= ~clk;
   end
   imem  imem_1(.a(iaddr[17:2]), .rd(instr) );

   rv32i rv32i_1(.clk(clk), .rst_n(rst_n), .instr(instr),
               .readdata(odata), .pc(iaddr), .aluresult(daddr),
               .writedata(wdata), .we(we), .req(req), .rdy(rdy), 
			   .ecall_op(ecall_op) );
	cache cache_1(.clk(clk), .rst_n(rst_n), .paddr(daddr[11:2]),
        .mdata(mdata), .pdata(wdata), .odata(odata), .we(we),
		        .maddr(maddr), .mem_rdy(mem_rdy), .mem_we(mem_we),
				        .rdy(rdy), .mem_req(mem_req), .req(req));
   mmem mmem_1(.clk(clk), .addr(daddr[11:2]),	.datain(wdata),
		.dataout(mdata), .rdy(mem_rdy), .req(mem_req), .rst_n(rst_n), 
		.we(1'b0), .block(1'b1));
	
   initial begin
      $dumpfile("rv32i.vcd");
      $dumpvars(0,test);
      $readmemh("imem.dat", imem);
      $readmemb("tmem.dat", cache_1.tagm);
      $readmemh("dmem.dat", mmem_1.mem);
	  count <= 0;
	  wcount <= 0;
	  hit <= 0;
	  miss <= 0;
      clk <= `DISABLE;
      rst_n <= `ENABLE_N;
   #(STEP*1/4)
   #STEP
      rst_n <= `DISABLE_N;
   #(STEP*400)            
   $finish;
   end

   always @(negedge clk) begin
   	  count <= count + 1;
      $display("count:%d pc:%h idatain:%h ", count, rv32i_1.pc, rv32i_1.instr);
	  $display("reg:%h %h %h %h %h %h %h | %h",
      rv32i_1.rfile_1.rf[1], rv32i_1.rfile_1.rf[2],
      rv32i_1.rfile_1.rf[3], rv32i_1.rfile_1.rf[4], rv32i_1.rfile_1.rf[5],
      rv32i_1.rfile_1.rf[6], rv32i_1.rfile_1.rf[7], rv32i_1.rfile_1.rf[31]);
      $display("cmem0-7:%h %h %h %h %h %h %h %h", 
	cache_1.cmem[0], cache_1.cmem[1], cache_1.cmem[2], 
	cache_1.cmem[3], cache_1.cmem[4], cache_1.cmem[5], 
	cache_1.cmem[6], cache_1.cmem[7]);
	if(req) begin
		if(cache_1.hit) begin
            hit <= hit+1;
            if(~we) $display("Dmem read %h: cache hit",daddr);
            if(we) $display("Dmem write %h: cache hit",daddr);
        end
        else if(~we) begin
            if(~mmem_1.rdy) begin
                $display("cache read miss wait"); wcount<=wcount+1; miss<=miss+1;
            end
            else begin
                $display("Dmem read %h: cache miss",daddr); wcount <= wcount + 1;
            end
        end
        else begin
            if(~mmem_1.rdy) begin
                $display("cache write miss wait"); wcount<=wcount+1; miss<=miss+1;
            end
            else begin
                $display("cache write miss direct write"); wcount<=wcount+1; miss<=miss+1;
            end
        end
    end
	if(cache_1.stat[`CRDY_BIT]) $display("Cache fill");

	if(ecall_op)  begin
	    $display("Clock Count: %d Wait Count: %d Hit:%d Miss:%d", count,wcount, hit ,miss); 
		$finish;
	end

   end
endmodule
