/*
 * <<< tracemaker_element.h >>>
 *
 * --- Processing Element for Tracemaker class 'tracemaker_element'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "tracemaker_element.h"

tracemaker_element::tracemaker_element(void)
	: shmem(NULL),
	  shfad(NULL),
	  old_adr(address_type(0)),
	  all_trace_flag(false)
{
	processor().port_ref().connect(shmem_ctl.port_ref());
	processor().port_ref().connect(shfad_ctl.port_ref());
	processor().port_ref().connect(bus_if);
	insert_synchronous_unit(shmem_ctl);
	insert_synchronous_unit(shfad_ctl);
}

tracemaker_element::tracemaker_element(const tracemaker_element& a)
	: shmem_ctl(a.shmem_ctl),
	  shmem(a.shmem),
	  shfad(a.shfad),
	  old_adr(a.old_adr),
	  all_trace_flag(a.all_trace_flag)
{
	processor().port_ref().connect(shmem_ctl.port_ref());
	processor().port_ref().connect(shfad_ctl.port_ref());
	processor().port_ref().connect(bus_if);
	insert_synchronous_unit(shmem_ctl);
	insert_synchronous_unit(shfad_ctl);
}

tracemaker_element::~tracemaker_element()
{}

tracemaker_element& tracemaker_element::operator=(const tracemaker_element& a)
{
	if (&a != this) {
		inherited::operator=(a);
		shmem_ctl = a.shmem_ctl;
		shfad_ctl = a.shfad_ctl;
		shmem = a.shmem;
		shfad = a.shfad;
		old_adr = a.old_adr;
	}
	return *this;
}

void tracemaker_element::connect_shared_memory
	(tracemaker_element::mapped_memory_type& a)
{
	shmem_ctl.connect_memory(a);
	memory_map().insert(a);
	shmem = &a;
	update_shared_memory_area();
}

void tracemaker_element::connect_sync_memory
	(tracemaker_element::mapped_memory_type& a)
{
	shfad_ctl.connect_memory(a);
	memory_map().insert(a);
	shfad = &a;
	update_sync_memory_area();
}

void tracemaker_element::update_shared_memory_area(void)
{
	if (shmem != NULL) {
		set_sysinfo("shared_memory_address", shmem->top());
		set_sysinfo("shared_memory_size", shmem->size());
	} else {
		set_sysinfo("shared_memory_address", data_type(0));
		set_sysinfo("shared_memory_size", data_type(0));
	}
}

void tracemaker_element::update_sync_memory_area(void)
{
	if (shfad != NULL) {
		set_sysinfo("sync_memory_address", shfad->top());
		set_sysinfo("sync_memory_size", shfad->size());
	} else {
		set_sysinfo("sync_memory_address", data_type(0));
		set_sysinfo("sync_memory_size", data_type(0));
	}
}

void tracemaker_element::set_shared_memory_read_wait(unsigned int a)
{
	shmem_ctl.set_read_wait(a);
}

void tracemaker_element::set_shared_memory_write_wait(unsigned int a)
{
	shmem_ctl.set_write_wait(a);
}

void tracemaker_element::set_sync_memory_read_wait(unsigned int a)
{
	shfad_ctl.set_read_wait(a);
}

void tracemaker_element::set_sync_memory_write_wait(unsigned int a)
{
	shfad_ctl.set_write_wait(a);
}
