/*
 * <<< tracemaker.cc >>>
 *
 * --- Tracemaker class 'tracemaker'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "tracemaker.h"

using namespace std;

tracemaker::tracemaker(void)
{}

tracemaker::tracemaker(size_t a)
	: pe(a)
{
	for (size_t i = 0; i < pe.size(); i++) {
		insert_synchronous_unit_set(pe[i]);
		pe[i].set_processor_number(pe.size());
		pe[i].set_processor_id(i);
		pe[i].connect_shared_memory(shmem);
		pe[i].connect_sync_memory(shfad);
	}
}

tracemaker::tracemaker(const tracemaker& a)
	: pe(a.pe),
	  shmem(a.shmem),
	  shfad(a.shfad)
{
	for (size_t i = 0; i < pe.size(); i++) {
		insert_synchronous_unit_set(pe[i]);
		pe[i].connect_shared_memory(shmem);
		pe[i].connect_sync_memory(shfad);
	}
}

tracemaker::~tracemaker()
{}

void tracemaker::set_processor_number(size_t a)
{
	if (a >= 0) {
		pe.resize(a);
		for (size_t i = 0; i < pe.size(); i++) {
			insert_synchronous_unit_set(pe[i]);
			pe[i].set_processor_number(pe.size());
			pe[i].set_processor_id(i);
			pe[i].connect_shared_memory(shmem);
			pe[i].connect_sync_memory(shfad);
		}
	}
}

void tracemaker::output(ostream& os) const
{
	for (size_t i = 0; i < pe.size(); i++) {
		os << "pe" << i << ": " << pe[i] << '\n';
	}
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

void tracemaker::set_shared_memory_area
	(tracemaker::address_type top, tracemaker::size_type size)
{
	shmem.set_top(top);
	shmem.resize(size);
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].update_shared_memory_area();
	}
}

void tracemaker::set_sync_memory_area
	(tracemaker::address_type top, tracemaker::size_type size)
{
	shfad.set_top(top);
	shfad.resize(size);
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].update_sync_memory_area();
	}
}

void tracemaker::output_trace(ostream& os) const
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].output_trace(os);
}

void tracemaker::enable_all_trace(void)
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].enable_all_trace();
}

void tracemaker::disable_all_trace(void)
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].disable_all_trace();
}

void tracemaker::enable_coprocessor(void)
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].enable_coprocessor();
}

void tracemaker::enable_instruction_cache(void)
{
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].enable_instruction_cache();
	}
}

void tracemaker::enable_data_cache(void)
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].enable_data_cache();
}

void tracemaker::disable_coprocessor(void)
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].disable_coprocessor();
}

void tracemaker::disable_instruction_cache(void)
{
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].disable_instruction_cache();
	}
}

void tracemaker::disable_data_cache(void)
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].disable_data_cache();
}

void tracemaker::shared_memory_read_wait(unsigned int a)
{
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].set_shared_memory_read_wait(a);
	}
}

void tracemaker::shared_memory_write_wait(unsigned int a)
{
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].set_shared_memory_read_wait(a);
	}
}

void tracemaker::sync_memory_read_wait(unsigned int a)
{
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].set_sync_memory_read_wait(a);
	}
}

void tracemaker::sync_memory_write_wait(unsigned int a)
{
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].set_sync_memory_read_wait(a);
	}
}
