/* -*- C++ -*-
 * Copyright (c) 1995-1996 Tohru Kisuki
 *               1995-2003 Masaki Wakabayashi
 *               1998 Keisuke Inoue
 *      	 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */
/*
 * <<< snoop_cache_element.h >>>
 * This class is processing element with snoop cache.
 */
#ifndef SNOOP_CACHE_ELEMENT_H
#define SNOOP_CACHE_ELEMENT_H

#include <iostream>
#include <string>
#include <isis/isis.h>
#include "cache_protocol.h"
#include "cache_controller.h"
// for verify
#include <isis/mapped_memory.h>
#include <isis/bus_port.h>

class arbiter;

class snoop_cache_element : public r3081_processing_element
{
private:
	typedef snoop_cache_element self_type;
	typedef r3081_processing_element base_type;
public:
	typedef base_type::address_type address_type;
	typedef base_type::data_type data_type;
	typedef base_type::char_type char_type;
	typedef base_type::size_type size_type;
	typedef base_type::processor_type processor_type;
	typedef base_type::memory_map_type memory_map_type;
	static const size_type sizeof_data_type = base_type::sizeof_data_type;
	typedef mapped_memory<address_type, data_type, sizeof_data_type, char_type>
		mapped_memory_type;
	typedef const cache_controller<r3000_word> const_cache_controller_type;
	typedef cache_controller<r3000_word> cache_controller_type;
	typedef bus_port<address_type, data_type> bus_port_type;
private:
	typedef cache_line_PROTOCOL<r3000_word, r3000_word> cache_line_t;
	set_associative_cache<cache_line_t> cache_buf;
	cache_controller<r3000_word> cache_ctl;
	tracewriter_unit<r3000_word> trw;
public:
	snoop_cache_element();
	snoop_cache_element(const self_type&);
	virtual ~snoop_cache_element() {}
	const_cache_controller_type& cache_controller() const {
		return cache_ctl; }
	cache_controller_type& cache_controller() {
		return cache_ctl; }
	virtual void output(std::ostream&) const;
	virtual bool output(std::ostream&, const std::string&) const;
	self_type& operator=(const self_type&);
	const port& port_ref() const {
		return cache_ctl.shared_bus_port(); }
	port& port_ref() {
		return cache_ctl.shared_bus_port(); }
	virtual void set_processor_id(size_t);
	virtual address_type shared_memory_address(void) const
		{ return address_type(get_integer_sysinfo("shared_memory_address")); }
	virtual size_type shared_memory_size(void) const
		{ return size_type(get_integer_sysinfo("shared_memory_size")); }
	virtual address_type sync_memory_address(void) const
		{ return address_type(get_integer_sysinfo("sync_memory_address")); }
	virtual size_type sync_memory_size(void) const
		{ return size_type(get_integer_sysinfo("sync_memory_size")); }
	virtual void set_shared_memory_area(address_type, size_type);
	virtual void set_sync_memory_area(address_type, size_type);
	void update_shared_memory_area(void);
	void set_cache_size(size_type, size_type, size_t);
	// arbiter
	void connect_sender_arb(arbiter& a) {
		cache_ctl.connect_sender_arb(a); }
	void disconnect_sender_arb() {
		cache_ctl.disconnect_sender_arb(); }
	int is_connected_sender_arb() const {
		return cache_ctl.is_connected_sender_arb(); }
	//
	void enable_trace(std::ostream& = std::cout);
	void disable_trace();
	// for verify
	void connect_mem(mapped_memory_type *sh, mapped_memory_type *sy) {
		cache_ctl.connect_mem(sh, sy); }
	bool is_connected_mem() {
		return cache_ctl.is_connected_mem(); }
	void disconnect_mem() {
		cache_ctl.disconnect_mem(); }
	void connect_mem_port(bus_port_type& a) {
		cache_ctl.connect_mem_port(a); }
	void disconnect_mem_port() {
		cache_ctl.disconnect_mem_port(); }
	void disconnect_mem_port(bus_port_type& a) {
		cache_ctl.disconnect_mem_port(a); }
	bool is_connected_mem_port() const {
		return cache_ctl.is_connected_mem_port(); }
	bool is_connected_mem_port(const bus_port_type& a) const {
		return cache_ctl.is_connected_mem_port(a); }
};

#endif // SNOOP_CACHE_ELEMENT_H
