/* -*- C++ -*-
 * Copyright (c) 1995-1996 Tohru Kisuki
 *               1995-2001 Masaki Wakabayashi
 *               1998 Keisuke Inoue
 *      	 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "snoop_cache.h"

using namespace std;

snoop_cache::snoop_cache()
	: bus_if(),
	  sender(1, 0)
{
	insert_synchronous_unit(shmem_ctl);
	insert_synchronous_unit(symem_ctl);
	insert_synchronous_unit(bus_if);
	shmem_ctl.connect_memory(shmem);
	symem_ctl.connect_memory(symem);
	shmem_ctl.port_ref().connect(symem_ctl.port_ref());
	bus_if.connect_external_bus_port(symem_ctl.port_ref());
}

snoop_cache::snoop_cache(size_t a)
	: pe(a),
	  bus_if(),
	  sender(1, a)
{
	insert_synchronous_unit(shmem_ctl);
	insert_synchronous_unit(symem_ctl);
	insert_synchronous_unit(bus_if);
	shmem_ctl.connect_memory(shmem);
	symem_ctl.connect_memory(symem);
	shmem_ctl.port_ref().connect(symem_ctl.port_ref());
	bus_if.connect_external_bus_port(symem_ctl.port_ref());
	for (size_t i = 0; i < pe.size(); i++) {
		insert_synchronous_unit_set(pe[i]);
		bus_if.connect_internal_bus_port(pe[i].port_ref());
		pe[i].set_processor_number(pe.size());
		pe[i].set_processor_id(i);
		pe[i].memory_map().insert(shmem);
		pe[i].memory_map().insert(symem);
		pe[i].connect_sender_arb(sender);
		pe[i].connect_mem(&shmem, &symem);
		pe[i].connect_mem_port(bus_if.external_bus_port());
	}
}

snoop_cache::snoop_cache(const snoop_cache& a)
	: pe(a.pe),
	  shmem(a.shmem),
	  symem(a.symem),
	  shmem_ctl(a.shmem_ctl),
	  symem_ctl(a.symem_ctl),
	  bus_if(),
	  sender(a.sender)
{
	insert_synchronous_unit(shmem_ctl);
	insert_synchronous_unit(symem_ctl);
	insert_synchronous_unit(bus_if);
	shmem_ctl.connect_memory(shmem);
	symem_ctl.connect_memory(symem);
	shmem_ctl.port_ref().connect(symem_ctl.port_ref());
	bus_if.connect_external_bus_port(symem_ctl.port_ref());
	for (size_t i = 0; i < pe.size(); i++) {
		insert_synchronous_unit_set(pe[i]);
		bus_if.connect_internal_bus_port(pe[i].port_ref());
		pe[i].memory_map().insert(shmem);
		pe[i].memory_map().insert(symem);
		pe[i].set_shared_memory_area(shmem.top(), shmem.size());
		pe[i].set_sync_memory_area(symem.top(), symem.size());
		pe[i].connect_sender_arb(sender);
		pe[i].connect_mem(&shmem, &symem);
		pe[i].connect_mem_port(bus_if.external_bus_port());
	}
}

void snoop_cache::set_processor_number(size_t a)
{
	if (a >= 0) {
		pe.resize(a);
		sender.set_user_count(a);
		for (size_t i = 0; i < pe.size(); i++) {
			insert_synchronous_unit_set(pe[i]);
			bus_if.connect_internal_bus_port(pe[i].port_ref());
			pe[i].set_processor_number(pe.size());
			pe[i].set_processor_id(i);
			pe[i].memory_map().insert(shmem);
			pe[i].memory_map().insert(symem);
			pe[i].set_shared_memory_area(shmem.top(), shmem.size());
			pe[i].set_sync_memory_area(symem.top(), symem.size());
			pe[i].connect_sender_arb(sender);
			pe[i].connect_mem(&shmem, &symem);
			pe[i].connect_mem_port(bus_if.external_bus_port());
		}
	}
}

void snoop_cache::set_cache_size
	(snoop_cache::size_type a, snoop_cache::size_type b, size_t c)
{
	for (size_t i = 0; i < pe.size(); i++)
		pe[i].set_cache_size(a, b, c);
}

void snoop_cache::enable_trace(ostream& os)
{
	for (size_t i = 0; i < pe.size(); i++)
		pe[i].enable_trace(os);
}

void snoop_cache::disable_trace()
{
	for (size_t i = 0; i < pe.size(); i++)
		pe[i].disable_trace();
}

void snoop_cache::output(ostream& os) const
{
	for (size_t i = 0; i < pe.size(); i++) {
		os << "pe" << i << ": " << pe[i] << '\n';
	}
	os << "shbus: " << bus_if.internal_bus_port() << '\n'
	   << "bridg: " << bus_if << '\n'
	   << "exbus: " << bus_if.external_bus_port() << endl;
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

void snoop_cache::set_shared_memory_area
	(snoop_cache::address_type top, snoop_cache::size_type size)
{
	shmem.set_top(top);
	shmem.resize(size);
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].set_shared_memory_area(top, size);
	}
}

void snoop_cache::set_sync_memory_area
	(snoop_cache::address_type top, snoop_cache::size_type size)
{
	symem.set_top(top);
	symem.resize(size);
	for (size_t i = 0; i < pe.size(); i++) {
		pe[i].set_sync_memory_area(top, size);
	}
}

void snoop_cache::enable_coprocessor()
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].enable_coprocessor();
}
void snoop_cache::enable_instruction_cache()
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].enable_instruction_cache();
}

void snoop_cache::enable_data_cache()
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].enable_data_cache();
}

void snoop_cache::disable_coprocessor()
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].disable_coprocessor();
}

void snoop_cache::disable_instruction_cache()
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].disable_instruction_cache();
}

void snoop_cache::disable_data_cache()
{
	for (size_t i = 0; i < pe.size(); i++) pe[i].disable_data_cache();
}

void snoop_cache::shared_memory_read_wait(unsigned int a)
{
	return shmem_ctl.set_read_wait(a);
}

void snoop_cache::shared_memory_write_wait(unsigned int a)
{
	return shmem_ctl.set_write_wait(a);
}

void snoop_cache::sync_memory_read_wait(unsigned int a)
{
	return symem_ctl.set_read_wait(a);
}

void snoop_cache::sync_memory_write_wait(unsigned int a)
{
	return symem_ctl.set_write_wait(a);
}
