/*
 * <<< shared_bus_element.h >>>
 *
 * --- Processing element for shared bus architecture class
 *     'shared_bus_element'
 *     Copyright (C) 1998-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "shared_bus_element.h"

using namespace std;

shared_bus_element::shared_bus_element(void)
{
	processor().port_ref().connect(shbus_if.local_bus_port());
	insert_synchronous_unit(shbus_if);
	set_shared_memory_area(0, 0);
	set_sync_memory_area(0, 0);
}

shared_bus_element::shared_bus_element(const shared_bus_element& a)
	: inherited(a)
{
	processor().port_ref().connect(shbus_if.local_bus_port());
	insert_synchronous_unit(shbus_if);
}

void shared_bus_element::set_processor_id(size_t a)
{
	inherited::set_processor_id(a);
	shbus_if.shared_bus_port().set_id(a);
}

void shared_bus_element::set_shared_memory_area
	(shared_bus_element::address_type a, shared_bus_element::size_type b)
{
	set_sysinfo("shared_memory_address", a);
	set_sysinfo("shared_memory_size", b);
	update_shared_memory_area();
}

void shared_bus_element::set_sync_memory_area
	(shared_bus_element::address_type a, shared_bus_element::size_type b)
{
	set_sysinfo("sync_memory_address", a);
	set_sysinfo("sync_memory_size", b);
	update_shared_memory_area();
}

void shared_bus_element::update_shared_memory_area(void)
{
	address_type mtop = shared_memory_address(), ftop = sync_memory_address();
	size_type msiz = shared_memory_size(), fsiz = sync_memory_size();
	address_type mbot = mtop + msiz, fbot = ftop + fsiz;
	address_type top = (mtop < ftop) ? mtop : ftop,
				 bottom = (mbot > fbot) ? mbot : fbot;
	shbus_if.set_valid_address(top, bottom - top);
}
