/*
 * <<< gdb_stub.cc >>>
 *
 * --- Test program for gdb_stub
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <isis/r3000_typedef.h>
#include <isis/r3000_processing_element.h>
#include "gdb_stub.h"

using namespace std;

int main(int, char** argv)
{
	int udp_flag = 0;
	while (*++argv != NULL && **argv == '-') {
		while (*++*argv != '\0') {
			switch (**argv) {
			case 'u': udp_flag = 1; break;
			default: break;
			}
		}
	}
	if (*argv == NULL) {
		cerr << "No executable file specified." << endl;
		return 1;
	}
	r3000_processing_element pe;
	if (!pe.load(*argv)) return 1;
	pe.set_instruction_cache_size(0x2000, 0x10);
	pe.set_data_cache_size(0x2000, 0x10);
	pe.set_commandline_argument((const char* const*)(argv));
	gdb_stub<r3000_word> stub;
	stub.set_singleprocessor(pe);
	stub.set_debug_output(cerr);
	stub.set_verbose();
	if (udp_flag) stub.use_udp();
	stub.service();
	return 0;
}
