/* -*- C++ -*-
 *
 * <<< single_processing_element.h >>>
 *
 * --- Abstract processing element class 'single_processing_element'
 *     Copyright (C) 1997-2002 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef SINGLE_PROCESSING_ELEMENT_H
#define SINGLE_PROCESSING_ELEMENT_H 1

#include <cstddef>
#include <iostream>
#include <string>
#include <isis/synchronous_unit_set.h>
#include <isis/processor.h>
#include <isis/memory_map.h>

template <class A, class D = A, size_t Dsz = sizeof(D), class Ch = char>
class single_processing_element : public synchronous_unit_set
{
public:
	typedef A address_type;
	typedef D data_type;
	typedef Ch char_type;
	typedef A size_type;
	typedef processor<A, D> processor_type;
	typedef memory_map<A, D, Dsz, Ch> memory_map_type;
	static const size_t sizeof_data_type = Dsz;
private:
	typedef single_processing_element<A, D, Dsz, Ch> thisclass;
	typedef synchronous_unit_set inherited;
public:
	virtual ~single_processing_element();
	virtual const processor_type& processor(void) const = 0;
	virtual processor_type& processor(void) = 0;
	virtual const memory_map_type& memory_map(void) const = 0;
	virtual memory_map_type& memory_map(void) = 0;
	virtual bool is_halt(void) const = 0;
	virtual bool is_bus_error(void) const = 0;
	virtual address_type bus_error_address(void) const = 0;
	virtual size_t processor_number(void) const = 0;
	virtual size_t processor_id(void) const = 0;
	virtual void set_processor_number(size_t) = 0;
	virtual void set_processor_id(size_t) = 0;
	virtual void set_file_table_size(size_t);
	virtual void set_standard_input_stream(std::istream&);
	virtual void set_standard_output_stream(std::ostream&);
	virtual void set_standard_error_stream(std::ostream&);
	virtual void set_commandline_argument(const char* const*);
	virtual int commandline_status(void) const;
	virtual bool is_defined_sysinfo(const std::string&) const;
	virtual bool is_integer_sysinfo(const std::string&) const;
	virtual bool is_string_sysinfo(const std::string&) const;
	virtual data_type get_integer_sysinfo(const std::string&) const;
	virtual const std::string& get_string_sysinfo(const std::string&) const;
	virtual void set_sysinfo(const std::string&, data_type);
	virtual void set_sysinfo(const std::string&, const std::string&);
	virtual void unset_sysinfo(const std::string&);
	virtual data_type timer_clock_value(void) const;
	virtual bool load(const char*);
	virtual void disassemble(std::ostream&, address_type, size_type) const;
	virtual bool output(std::ostream&, const std::string&) const;
};

template <class A, class D, size_t Dsz, class Ch>
single_processing_element<A, D, Dsz, Ch>::~single_processing_element()
{}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::set_file_table_size(size_t)
{}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::set_standard_input_stream
	(std::istream&)
{}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::set_standard_output_stream
	(std::ostream&)
{}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::set_standard_error_stream
	(std::ostream&)
{}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::set_commandline_argument
	(const char* const*)
{}

template <class A, class D, size_t Dsz, class Ch>
int single_processing_element<A, D, Dsz, Ch>::commandline_status(void) const
{
	return 0;
}

template <class A, class D, size_t Dsz, class Ch>
bool single_processing_element<A, D, Dsz, Ch>::is_defined_sysinfo
	(const std::string&) const
{
	return false;
}

template <class A, class D, size_t Dsz, class Ch>
bool single_processing_element<A, D, Dsz, Ch>::is_integer_sysinfo
	(const std::string&) const
{
	return false;
}

template <class A, class D, size_t Dsz, class Ch>
bool single_processing_element<A, D, Dsz, Ch>::is_string_sysinfo
	(const std::string&) const
{
	return false;
}

template <class A, class D, size_t Dsz, class Ch>
typename single_processing_element<A, D, Dsz, Ch>::data_type
	single_processing_element<A, D, Dsz, Ch>::get_integer_sysinfo
	(const std::string&) const
{
	static data_type dummy = 0;
	return dummy;
}

template <class A, class D, size_t Dsz, class Ch>
const std::string& single_processing_element<A, D, Dsz, Ch>::get_string_sysinfo
	(const std::string&) const
{
	static std::string dummy;
	return dummy;
}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::set_sysinfo
	(const std::string&, data_type)
{}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::set_sysinfo
	(const std::string&, const std::string&)
{}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::unset_sysinfo(const std::string&)
{}

template <class A, class D, size_t Dsz, class Ch>
typename single_processing_element<A, D, Dsz, Ch>::data_type
single_processing_element<A, D, Dsz, Ch>::timer_clock_value(void) const
{
	return data_type(0);
}

template <class A, class D, size_t Dsz, class Ch>
bool single_processing_element<A, D, Dsz, Ch>::load(const char*)
{
	return false;
}

template <class A, class D, size_t Dsz, class Ch>
void single_processing_element<A, D, Dsz, Ch>::disassemble
	(std::ostream&,
	 typename single_processing_element<A, D, Dsz, Ch>::address_type,
	 typename single_processing_element<A, D, Dsz, Ch>::size_type) const
{}

template <class A, class D, size_t Dsz, class Ch>
bool single_processing_element<A, D, Dsz, Ch>::output
	(std::ostream&, const std::string&) const
{
	return false;
}

#endif /* SINGLE_PROCESSING_ELEMENT_H */
