/* -*- C++ -*-
 *
 * <<< single_port_synchronous_unit.h >>>
 *
 * --- Abstract single-port synchronous unit class
 *     'single_port_synchronous_unit'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef SINGLE_PORT_SYNCHRONOUS_UNIT_H
#define SINGLE_PORT_SYNCHRONOUS_UNIT_H 1

#include <isis/synchronous_unit.h>
#include <isis/port.h>

class single_port_synchronous_unit : public synchronous_unit 
{
private:
	typedef single_port_synchronous_unit thisclass;
	typedef synchronous_unit inherited;
public:
	typedef port port_type;
	typedef port_type::id_type id_type;
public:
	virtual const port_type& port_ref(void) const = 0;
	virtual port_type& port_ref(void) = 0;
};

#endif /* SINGLE_PORT_SYNCHRONOUS_UNIT_H */
