/*
 * <<< loopback_router.h >>>
 *
 * --- Router class for loopback-path (only for test)
 *     Copyright (C) 2000-2002 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef LOOPBACK_ROUTER_H
#define LOOPBACK_ROUTER_H

#include <isis/deterministic_router.h>

template <class P>
class loopback_router : public deterministic_router<P>
{
private:
	typedef loopback_router<P> thisclass;
	typedef deterministic_router<P> inherited;
public:
	typedef typename inherited::packet_type packet_type;
	typedef typename inherited::node_address_type node_address_type;
	typedef typename inherited::channel_controller channel_controller;
protected:
	virtual void routing(const packet_type&, channel_controller&);
public:
	loopback_router(void);
	loopback_router(const loopback_router&);
	virtual ~loopback_router() {}
};

template <class P>
loopback_router<P>::loopback_router(void)
	: inherited()
{
	set_input_size(1);
	set_output_size(1);
	set_channel_size(0, 1);
	set_buffer_size(0, 1);
}

template <class P>
loopback_router<P>::loopback_router(const loopback_router& a)
	: inherited(a)
{}

template <class P>
void loopback_router<P>::routing
	(const packet_type& pkt, channel_controller& ctl)
{
	ctl.set_destination(pkt.destination(), 0);
}

#endif /* LOOPBACK_ROUTER_H */
