/*
 * <<< halt_detector_test.cc >>>
 *
 * --- Test program for halt_detector class
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <isis/bus_port.h>
#include "halt_detector.h"

using namespace std;

int main(void)
{
	typedef unsigned int word;
	halt_detector<word> mon;
	bus_port<word> bus_if;
	mon.port_ref().connect(bus_if);
	mon.set_address(0x10);
	cout << hex;
	for (word adr = 0; adr < 0x20; adr += sizeof(word)) {
		cout << "0x" << adr << ": " << bus_if << ", " << mon << endl;
		if (mon.is_halt()) break;
		bus_if.send_single_write_request(adr);
		mon.clock_in();
		mon.clock_out();
	}
	return 0;
}
