/*
 * <<< cyclic_queue_test.cc >>>
 *
 * --- Test program for cyclic_queue class
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include "cyclic_queue.h"

using namespace std;

int main(void)
{
	const size_t size = 10;
	cyclic_queue<int> buf(size);
	int i;
	for (i = 0; !buf.full(); i++) buf.push(i);
	cout << "size: " << buf.size() << endl;
	buf.reserve(size * 2);
	for (i = 0; !buf.full(); i++) buf.push(i);
	cout << "size: " << buf.size() << endl;
	while (!buf.empty()) {
		cout << buf.front() << ' ';
		buf.pop();
	}
	cout << endl;
	return 0;
}
