/* -*- C++ -*-
 *
 * <<< checked_vector.h >>>
 *
 * --- Vector with out_of_range check class 'checked_vector'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef CHECKED_VECTOR_H
#define CHECKED_VECTOR_H 1

#ifdef DEBUG
# include <cassert>
#endif // DEBUG
#include <vector>

template < class T, class A = std::allocator<T> >
class checked_vector : public std::vector<T, A>
{
private:
	typedef checked_vector<T, A> thisclass;
	typedef std::vector<T, A> inherited;
public:
	typedef typename inherited::value_type value_type;
	typedef typename inherited::allocator_type allocator_type;
	typedef typename inherited::size_type size_type;
	typedef typename inherited::difference_type difference_type;
	typedef typename inherited::reverse_iterator reverse_iterator;
	typedef typename inherited::const_reverse_iterator const_reverse_iterator;
	typedef typename inherited::pointer pointer;
	typedef typename inherited::const_pointer const_pointer;
	typedef typename inherited::reference reference;
	typedef typename inherited::const_reference const_reference;
	explicit checked_vector(const allocator_type& a = allocator_type())
		: inherited(a) {}
	explicit checked_vector(size_type n, const value_type& val = value_type(),
							const allocator_type& a = allocator_type())
		: inherited(n, val, a) {}
	template <class In>
	checked_vector(In f, In l, const allocator_type& a = allocator_type())
		: inherited(f, l, a) {}
	checked_vector(const_reference a) : inherited(a) {}
	~checked_vector() {}
	reference operator=(const thisclass& a)
		{ return reference(inherited::operator=(a)); }
	inline const_reference operator[](size_type) const;
	inline reference operator[](size_type);
};

template <class T, class A>
inline checked_vector<T, A>::const_reference checked_vector<T, A>::operator[]
	(checked_vector<T, A>::size_type i) const
{
#ifdef DEBUG
	assert(i < size());
#endif // DEBUG
	return inherited::operator[](i);
}

template <class T, class A>
inline checked_vector<T, A>::reference checked_vector<T, A>::operator[]
	(checked_vector<T, A>::size_type i)
{
#ifdef DEBUG
	assert(i < size());
#endif // DEBUG
	return inherited::operator[](i);
}

#endif /* CHECKED_VECTOR_H */
