/*
 * <<< c_array_test.cc >>>
 *
 * --- Test program for c_array class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <vector>
#include "c_array.h"

using namespace std;

int main(void)
{
	typedef int data_type;
	const size_t size = 32;
	typedef c_array<data_type, size> container_type;
	typedef vector<data_type> temporary_container_type;
	container_type src, dst;
	temporary_container_type tmp(src.size());
	{
		// initialize src
		for (size_t i = 0; i < src.size(); i++) src[i] = i;
	}
	{
		// copy from src to tmp
		container_type::const_iterator s = src.begin(), e = src.end();
		temporary_container_type::iterator d = tmp.begin();
		while (s != e) *d++ = *s++;
	}
	{
		// copy from tmp to dst
		temporary_container_type::const_iterator s = tmp.begin(), e = tmp.end();
		container_type::iterator d = dst.begin();
		while (s != e) *d++ = *s++;
	}
	{
		// compare src and dst
		size_t i;
		for (i = 0; i < src.size(); i++) {
			if (src[i] != dst[i]) break;
		}
		return (i == src.size()) ? 0 : 1;
	}
}
