/*
 * <<< bitvector_test.cc >>>
 *
 * --- Test program for bitvector class
 *     Copyright (C) 2000-2002 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <iomanip>
#include <vector>
#include "bitvector.h"

using namespace std;

#define rnd() ((unsigned int)((seed = 1566083941UL * seed + 1) >> 16))
static unsigned long seed = 1;

int main(int argc, char** argv)
{
	const size_t size = (argc > 1) ? atoi(argv[1]) : 64;
	const size_t iter = (argc > 1) ? atoi(argv[1]) : 100;
	bitvector a(size), b;
	vector<bitvector> buf(iter);
	size_t i;
	for (i = 0; i < size; i++) {
		if (((rnd() >> 6) & 1) != 0) a.set(i);
	}
	cout << "source:   " << a << endl;
	for (i = 0; i < iter; i++) {
		int func = (rnd() >> 6) % 3;
		size_t val = (rnd() >> 6) % size;
		if (i % 10 == 0) {
			cout << "          ";
			for (size_t j = 0; j < size; j++) {
				cout << ((j % 10 == 0) ? '|' : ((j % 5 == 0) ? '+' : '-'));
			}
			cout << endl;
		}
		switch (func) {
		case 0:
			a.set(val);
			cout << "set   " << setw(2) << val << ": " << a << endl;
			break;
		case 1:
			a.reset(val);
			cout << "reset " << setw(2) << val << ": " << a << endl;
			break;
		default:
			a.flip(val);
			cout << "flip  " << setw(2) << val << ": " << a << endl;
			break;
		}
		buf[i] = a;
	}
	for (i = 0; i < iter; i++) {
		int func = (rnd() >> 6) % 3;
		size_t s1 = (rnd() >> 6) % iter, s2 = (rnd() >> 6) % iter;
		a = buf[s1];
		b = buf[s2];
		cout << endl
			 << "a  : " << a << endl
			 << "b  : " << b << endl;
		switch (func) {
		case 0:
			cout << "a&b: " << (a & b) << endl;
			break;
		case 1:
			cout << "a|b: " << (a | b) << endl;
			break;
		default:
			cout << "a^b: " << (a ^ b) << endl;
			break;
		}
	}
	return 0;
}
