/* -*- C++ -*-
 *
 * <<< argument_parser.h >>>
 *
 * --- Command-line argument parser class 'argument_parser'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef ARGUMENT_PARSER_H
#define ARGUMENT_PARSER_H 1

#include <iostream>

class argument_parser
{
private:
	typedef argument_parser thisclass;
	char* short_index;
	char** short_value;
	char** long_index;
	char** long_value;
	char** args;
	void assign(const thisclass&);
public:
	argument_parser(void);
	explicit argument_parser(const char* const*);
	argument_parser(const thisclass&);
	~argument_parser();
	thisclass& operator=(const thisclass&);
	void output(std::ostream&) const;
	void set(const char* const*);
	void clear(void);
	bool defined(char) const;
	bool defined(const char*) const;
	const char* operator[](char) const;
	const char* operator[](const char*) const;
	const char* const* argument(void) const { return args; }
};

std::ostream& operator<<(std::ostream&, const argument_parser&);

#endif /* ARGUMENT_PARSER_H */
